﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Filters;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;

namespace SamplePlugin
{
	class SampleFilter : TerminalFilter
	{
		Explosion explosion;
		string projectile;

		List<int> care = new List<int>();
		bool check = false;		

		public SampleFilter(Explosion explosion, StatsRegistry reg)
		{
			this.explosion = explosion;
			projectile = explosion.Event.Parameters["projectile_id"];
			
			var desc = reg.GetEventDesc("hit");
			if(desc != null)
				care.Add(desc.ID);
			
			desc = reg.GetEventDesc("shot");
			if (desc != null)
				care.Add(desc.ID);

			desc = reg.GetEventDesc("death");
			if (desc != null)
				care.Add(desc.ID);
		}

		public override object Clone()
		{
			throw new NotImplementedException();
		}

		public override EFilterState TestEventGroup(GameEventGroup group)
		{
			check = care.Contains(group.Desc.ID);
			return EFilterState.Unaffected;
		}

		public override EFilterState TestEvent(GameEvent evnt)
		{
			string prj;
			if (check 
				&& evnt.Parameters.TryGetValue("projectile_id", out prj) 
				&& prj == projectile
				|| explosion.Event == evnt)
				return EFilterState.Passed;

			return EFilterState.Failed;
		}
	}
}
