﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using StatsDataSource.Filters;
using StatsDataSource.Storage;
using StatsGameK01;

namespace SamplePlugin
{
	public partial class SampleForm : Form
	{
		//////////////////////////////////////////////////////////////////////////

		readonly string EMPTY_SELECTION = "<none>";
		public SamplePlugin MyPlugin;
		public Form MainForm;

		SampleFilter m_filter;
		SampleFilter ExplosionFilter
		{
			get { return m_filter; }
			set
			{
				bool changed = false;

				if (m_filter != null)
				{
					changed = true;
					MyPlugin.Core.Repository.RemoveSubFilter(m_filter);
				}

				m_filter = value;

				if (m_filter != null)
				{
					changed = true;
					MyPlugin.Core.Repository.AddSubFilter(m_filter);
				}

				if(changed)
					MyPlugin.Core.Repository.UpdateFilter(EFilterUpdateType.Regular, null);
			}
		}

		ViewCallback m_callback;

		//////////////////////////////////////////////////////////////////////////

		public SampleForm(SamplePlugin plugin)
		{
			MyPlugin = plugin;
			MainForm = plugin.MainForm as Form;

			InitializeComponent();

			MainForm.Move += MainForm_Move;
			cbSpawn.Items.Add(EMPTY_SELECTION);
			cbSpawn.SelectedIndex = 0;
		}

		//////////////////////////////////////////////////////////////////////////

		private void SampleForm_Load(object sender, EventArgs e)
		{
			MainForm_Move(null, null);
		}

		private void SampleForm_FormClosed(object sender, FormClosedEventArgs e)
		{
			ExplosionFilter = null;
			MyPlugin.OnFormClosed();
		}

		//////////////////////////////////////////////////////////////////////////

		void MainForm_Move(object sender, EventArgs e)
		{
			Point pos = MainForm.Location;
			Point wh = new Point(MainForm.Width, MainForm.Height);
			this.Location = new Point(pos.X + wh.X, pos.Y + wh.Y - this.Height);
		}

		//////////////////////////////////////////////////////////////////////////

		private void cbSpawn_DropDown(object sender, EventArgs e)
		{
			if (cbSpawn.Items.Count == 1)
			{
				ExplodeCollectVisitor collect = new ExplodeCollectVisitor(MyPlugin.Core.Repository);
				MyPlugin.Core.Repository.AcceptVisitor(collect);

				foreach (Explosion ex in collect.Explosions)
					cbSpawn.Items.Add(ex);
			}
		}

		private void cbSpawn_SelectedIndexChanged(object sender, EventArgs e)
		{
			var mode = MyPlugin.MiniMap.Renderer.GetRenderModes().Find(M => M.Name == "Markers") as IMarkerRenderMode;

			if (cbSpawn.Text != EMPTY_SELECTION)
			{
				ExplosionFilter = new SampleFilter((Explosion)cbSpawn.SelectedItem, MyPlugin.Core.Repository.Registry);

				if (m_callback == null && mode != null)
				{
					MyPlugin.MiniMap.Renderer.Percise = true;

					m_callback = new ViewCallback();
					mode.AddViewCallback(m_callback);
				}
			}
			else
			{
				MyPlugin.MiniMap.Renderer.Percise = false;

				ExplosionFilter = null;

				if (mode != null)
				{
					mode.RemoveViewCallback(m_callback);
					m_callback = null;
				}
			}		
		}

		//////////////////////////////////////////////////////////////////////////
	}

	//////////////////////////////////////////////////////////////////////////

	class ViewCallback : IMarkerViewCallback
	{
		public int GetSpriteID(MarkerInfo mi)
		{
			return mi.Event.Group.Desc.Name == "explode" ? 3 : -1;
		}

		public Color GetPathColor(PathData path)
		{
			return Color.Black;
		}
	}
}
