﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Core;
using System.Windows.Forms;
using StatsGameK01;

namespace SamplePlugin
{
	public class SamplePlugin : IStatsPlugin
	{
		//////////////////////////////////////////////////////////////////////////

		#region IStatsPlugin Members

		public string getName() 
		{
			return "Sample plug-in"; 
		}

		public int getUsedTagCount() 
		{ 
			return 0;
		}

		public IPluginAction[] getActions() 
		{ 
			return new IPluginAction[] { showAction }; 
		}

		public StatsCore Core;
		public IMainForm MainForm;
		public IMiniMapPlugin MiniMap;

		public void Start(StatsCore Core, IMainForm MainForm, int tagBias)
		{
			this.Core = Core;
			this.MainForm = MainForm;

			MiniMap = (IMiniMapPlugin) Core.Plugins.Find(P => P is IMiniMapPlugin);

			showAction = new DelegAction("&Windows/Show &sample plug-in", DoShowAction);
		}

		public void HandleCoreMessage(ECoreMessage msg)
		{
		}

		public void Stop()
		{
		}

		#endregion

		//////////////////////////////////////////////////////////////////////////

		#region Actions

		DelegAction showAction;

		SampleForm myForm;

		void DoShowAction(IPluginAction action)
		{
			if (myForm == null)
			{
				MainForm.SetStatus("Initializing sample plug-in window");
				myForm = new SampleForm(this);
				myForm.Show(MainForm as Form);
			}
			else
			{
				MainForm.SetStatus("Closing sample plug-in window");
				myForm.Close();
				myForm = null;
			}

			showAction.setIsEnabled(myForm != null);
		}

		public void OnFormClosed()
		{
			if (MainForm != null)
			{
				MainForm = null;
				showAction.setIsEnabled(false);
			}
		}

		#endregion

		//////////////////////////////////////////////////////////////////////////
	}
}
