using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using StatsParse;

namespace StatsCharts
{
	class CRicochetStats
	{
	  public int m_hits;
	  public int m_kills;
	  public double m_damage;
	}

	public class CRicochetInfoWorker : IStatsChartsWorker
	{
	  public EChartKind GetChartKind()
	  {
	    return EChartKind.Ricochet_info;
	  }

		private void AddKeyIfNeeded(Dictionary<string, CRicochetStats> dict, string key )
		{
			if ( !dict.ContainsKey(key) )
				dict[key] = new CRicochetStats();
		}

	  public void MakeChartXml(Dictionary<string, CSessionRoot> sessions, SFiterData filter, string outFileName)
	  {
	    Dictionary<string, CRicochetStats> totalStats			= new Dictionary<string, CRicochetStats>();
			Dictionary<string, CRicochetStats> ricochetStats	= new Dictionary<string, CRicochetStats>();

		  foreach ( KeyValuePair<string, CSessionRoot> snKvp in sessions )
		  {
		    if (snKvp.Value.m_roundData == null)
		      continue;

		    foreach (CRoundData rd in snKvp.Value.m_roundData)
		    {
		      if (rd.m_playerLifes == null)
		        continue;

		      foreach ( CPlayerLife pl in rd.m_playerLifes )
		      {
		        ITimelineValue[] hitTL	= StatsChartsUtils.GetTimeline("hit",		pl);
		        ITimelineValue[] killTL	= StatsChartsUtils.GetTimeline("kill",	pl);

		        foreach (CHitTimelineValue hv in hitTL)
		        {
							string weapClass = hv.m_weaponClass;
							if ( weapClass == null )
								continue;

							bool isRicochet = hv.m_ricochetCount > 0;

              AddKeyIfNeeded(totalStats,	weapClass);
							AddKeyIfNeeded(ricochetStats,	weapClass);

							totalStats[weapClass].m_hits+= 1;
							totalStats[weapClass].m_damage+= hv.m_damage;
		          if ( isRicochet )
							{
								ricochetStats[weapClass].m_hits+= 1;
								ricochetStats[weapClass].m_damage+= hv.m_damage;
							}

		          foreach( CKillTimelineValue kv in killTL)
								if ( kv.m_projectileId == hv.m_projectileId )
								{
									totalStats[weapClass].m_kills += 1;
									if (isRicochet)
										ricochetStats[weapClass].m_kills += 1;
								}
		        }
		      }
		    }
		  }

			XmlDocument doc = new XmlDocument();
			XmlElement root = doc.CreateElement("stats");
			
			SortedDictionary<string, CRicochetStats> sortedTotalStats = new SortedDictionary<string, CRicochetStats>(totalStats);
			foreach( KeyValuePair<string, CRicochetStats> kvp in sortedTotalStats )
			{
			  CRicochetStats tv = kvp.Value;
				CRicochetStats rv = ricochetStats[kvp.Key];
			  XmlElement child = doc.CreateElement("weapon");

			  StatsChartsUtils.AddAttribute( child, "a_name",									kvp.Key,		doc );
			  StatsChartsUtils.AddAttribute( child, "b_hits_total",						tv.m_hits,	doc );
				StatsChartsUtils.AddAttribute( child, "c_hits_via_ricochet",		rv.m_hits,	doc );
			  StatsChartsUtils.AddAttribute( child, "d_kills_total",					tv.m_kills,	doc );
				StatsChartsUtils.AddAttribute( child, "e_kills_via_ricochet",		rv.m_kills,	doc );

				//Math.Round to remove troubles with floating point delimiter
				StatsChartsUtils.AddAttribute( child, "f_damage_total",					Math.Round(tv.m_damage),	doc );
				StatsChartsUtils.AddAttribute( child, "g_damage_via_ricochet",	Math.Round(rv.m_damage),	doc );

				root.AppendChild(child);
			}
			doc.AppendChild(root);
			doc.Save(outFileName);
		}

	}
}
