using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace StatsCharts
{
	public enum EChartKind
	{
		Attachment_info,
		Ricochet_info
	}

	public struct SFiterData
	{
		public string m_playerName;
	}

	interface IStatsChartsWorker
	{
		EChartKind GetChartKind();
		void MakeChartXml(Dictionary<string, StatsParse.CSessionRoot> sessions, SFiterData filter, string outFileName);
	}

	public static class CStatsChartsManager
	{
		public static bool MakeChartXml(EChartKind kind, Dictionary<string, StatsParse.CSessionRoot> sessions, SFiterData filter, string outFileName)
		{
			Assembly asm = Assembly.GetAssembly(typeof(CStatsChartsManager));
			Type[] asmTypes = asm.GetTypes();
			foreach (Type tp in asmTypes)
			{
				Type face = tp.GetInterface("IStatsChartsWorker");
				if (face != null)
				{
					IStatsChartsWorker worker = (IStatsChartsWorker)Activator.CreateInstance(tp);
					if (worker.GetChartKind() == kind)
					{
						worker.MakeChartXml(sessions, filter, outFileName);
						return true;
					}
				}
			}
			return false;
		}
	}
}
