using System;
using System.Collections.Generic;
using System.Text;
using StatsParse;
using System.Xml;

namespace StatsCharts
{
	static class StatsChartsUtils
	{
		public static ITimelineValue[] GetTimeline(string name, CPlayerLife pl)
		{
			ITimelineValue[] tmpTline;
			if (pl.EventTimelines.TryGetValue(name, out tmpTline))
				return tmpTline;

			return new ITimelineValue[0];
		}

		public static void AddAttribute(XmlElement to, string name, object val, XmlDocument doc)
		{
			XmlAttribute attr = doc.CreateAttribute(name);
			attr.Value = val.ToString();
			to.Attributes.Append(attr);
		}

		public static int GetIntersectionLength(int bgn1, int end1, int bgn2, int end2)
		{
			if (bgn1 > end2 || bgn2 > end1)
				return 0;

			int bgn = Math.Max(bgn1, bgn2);
			int end = Math.Min(end1, end2);

			return end - bgn;
		}
	}
}
