%namespace StatsDataSource.DataAccumulation

%visibility public

%scannertype DataAccScanner

whitespace		[ \t\n\r]
alphanum		[a-zA-Z_]+[a-zA-Z0-9_]*
string			\".*\"

%%

"["						|
"]"						|
"("						|
")"						|
"{"						|
"}"						|
"="						|
"."						|
","						|
":"						|
";"						{ yylval.Set(yytext); return yytext[0]; }

"context_set"			{ yylval.Set((int)Tokens.CONTEXT_SET);	return (int)Tokens.CONTEXT_SET; }
"context"				{ yylval.Set((int)Tokens.CONTEXT);		return (int)Tokens.CONTEXT; }
"stat"					{ yylval.Set((int)Tokens.STAT);			return (int)Tokens.STAT; }
"source"				{ yylval.Set((int)Tokens.SOURCE);		return (int)Tokens.SOURCE; }
"operation"				{ yylval.Set((int)Tokens.OPERATION);	return (int)Tokens.OPERATION; }

"player"				{ yylval.Set((int)Tokens.PLAYER);		return (int)Tokens.PLAYER; }
"scopes"				{ yylval.Set((int)Tokens.SCOPES);		return (int)Tokens.SCOPES; }
"elements"				{ yylval.Set((int)Tokens.ELEMENTS);		return (int)Tokens.ELEMENTS; }
"states"				{ yylval.Set((int)Tokens.STATES);		return (int)Tokens.STATES; }
"events"				{ yylval.Set((int)Tokens.EVENTS);		return (int)Tokens.EVENTS; }

"set"					{ yylval.Set((int)Tokens.OP_SET);		return (int)Tokens.OP_SET; }
"min"					{ yylval.Set((int)Tokens.OP_MIN);		return (int)Tokens.OP_MIN; }
"max"					{ yylval.Set((int)Tokens.OP_MAX);		return (int)Tokens.OP_MAX; }
"avg"					{ yylval.Set((int)Tokens.OP_AVG);		return (int)Tokens.OP_AVG; }
"sum"					{ yylval.Set((int)Tokens.OP_SUM);		return (int)Tokens.OP_SUM; }
"first"					{ yylval.Set((int)Tokens.OP_FIRST);		return (int)Tokens.OP_FIRST; }
"last"					{ yylval.Set((int)Tokens.OP_LAST);		return (int)Tokens.OP_LAST; }

"//".*					{ /*comment*/ }
{alphanum}				{ yylval.Set(yytext); return (int)Tokens.IDENTIFIER; }
{string}				{ yylval.Set(yytext.Substring(1, yytext.Length - 2)); return (int)Tokens.STRING; }

{whitespace}			{ }
.						{ yyerror("Unexpected symbol: " + yytext); return yytext[0]; }

%%

public override void yyerror(string format, params object[] args)
{
	base.yyerror(format, args);
	string error = string.Format("error in <filename>({0},{1}): {2}", yyline, yycol, format);
	Console.WriteLine(error);
	Errors.Add(error);
}

private List<string> m_errors = new List<string>();
public List<string> Errors { get { return m_errors; } }