%{
	private IDataAccParseCallback m_callback = new NullDataAccParseCallback();
	public IDataAccParseCallback Callback { get { return m_callback; } set { m_callback = value; } }
%}

%using StatsDataSource.Parsing
%namespace StatsDataSource.DataAccumulation
%parsertype DataAccParser

%visibility public

%YYSTYPE Token

%start DefinitionList
%token IDENTIFIER STRING FLOAT
%token CONTEXT_SET CONTEXT STAT SOURCE OPERATION
%token PLAYER
%token SCOPES ELEMENTS STATES EVENTS
%token OP_SET OP_MIN OP_MAX OP_AVG OP_SUM OP_FIRST OP_LAST

%left AND OR 
%left EQ NE
%left LS LE GT GE 
%right NOT


%%

DefinitionList			:	/*empty*/											{ }
						|	Definition											{ $$ = Callback.OnDefinitionList(null, $1.oVal); }
						|	DefinitionList Definition							{ $$ = Callback.OnDefinitionList($1.oVal, $2.oVal); }
						;
						
Definition				:	ContextSet
						|	StatDef
						;
						
						
ContextSet				:	CONTEXT_SET IDENTIFIER '{' ContextList '}'			{ $$ = Callback.OnContextSet($2, $4.oVal); }
						;
						

ContextList				:	Context												{ $$ = Callback.OnContextList(null, $1.oVal); }
						|	ContextList Context									{ $$ = Callback.OnContextList($1.oVal, $2.oVal); }
						;						
						
Context					:	CONTEXT '{' ContextElementList '}'					{ $$ = Callback.OnContext($3.oVal); }
						;
						
ContextElementList		:	/*empty*/											{ $$ = new Token(); }
						|	ContextElement										{ $$ = Callback.OnContextElementList(null, $1.oVal); }
						|	ContextElementList ContextElement					{ $$ = Callback.OnContextElementList($1.oVal, $2.oVal); }
						;
						
ContextElement			:	IDENTIFIER '=' Path ';'								{ $$ = Callback.OnContextElement($1, $3); }
						;
						
						
						
StatDef					:	STAT IDENTIFIER '{' StatContext StatSource StatOperation '}'	{ $$ = Callback.OnStatDef($2, $4, $5.oVal, $6.oVal); }
						|	STAT IDENTIFIER '{' StatContext StatOperation StatSource '}'	{ $$ = Callback.OnStatDef($2, $4, $6.oVal, $5.oVal); }
						;
						
StatContext				:	CONTEXT_SET '=' IDENTIFIER ';'						{ $$ = $3; }
						;
						
StatSource				:	SOURCE '=' SRCOperation '(' Path ')' ';'			{ $$ = Callback.OnStatSource((Tokens)$3.iVal, $5); }
						;
						
StatOperation			:	OPERATION '=' DBOperation ';'						{ $$ = Callback.OnStatOperation((Tokens)$3.iVal); }
						;

SRCOperation			: OP_MIN | OP_MAX | OP_AVG | OP_SUM | OP_FIRST | OP_LAST
						;
						
DBOperation				: OP_SET | OP_MIN | OP_MAX | OP_AVG | OP_SUM
						;
						
						
						
Path					:	PathElement											{ $$ = Callback.OnPath(null, $1); }
						|	Path '.' PathElement								{ $$ = Callback.OnPath($1.oVal, $3); }
						;
						
PathElement				:	IDENTIFIER											{ $$ = Callback.OnPathElement($1); }
						|	PathElemPDSingle									{ $$ = Callback.OnPathElement((Tokens)$1.iVal, null); }
						|	PathElemPDCollection CollectionSelectorList			{ $$ = Callback.OnPathElement((Tokens)$1.iVal, $2.oVal); }
						;
						
PathElemPDSingle		:	PLAYER
						;
						
PathElemPDCollection	:	SCOPES | ELEMENTS | STATES | EVENTS
						;
						
CollectionSelectorList	:	CollectionSelector									{ $$ = Callback.OnCollectionSelectorList(null, $1.oVal); }
						|	CollectionSelectorList CollectionSelector			{ $$ = Callback.OnCollectionSelectorList($1.oVal, $2.oVal); }
						;
						
CollectionSelector		:	'[' IDENTIFIER ']'									{ $$ = Callback.OnCollectionSelector($2); }
						;

%%

public DataAccParser(DataAccScanner scanner) : base(scanner) { }

public void SetError(string desc)
{
	Scanner.yyerror(desc);
	YYError();
}