%namespace StatsDataSource.Preprocessing

%visibility public

%scannertype EProcScanner

whitespace		[ \t\n\r]
alphanum		[a-zA-Z_]+[a-zA-Z0-9_]*
string			\".*\"

%%

"["						|
"]"						|
"("						|
")"						|
"{"						|
"}"						|
"="						|
"."						|
","						|
":"						|
";"						{ yylval.Set(yytext); return yytext[0]; }

"=="					{ yylval.Set((int)Tokens.EQ);			return (int)Tokens.EQ; }
"!="					{ yylval.Set((int)Tokens.EQ);			return (int)Tokens.NE; }
"<"						{ yylval.Set((int)Tokens.LS);			return (int)Tokens.LS; }
"<="					{ yylval.Set((int)Tokens.LE);			return (int)Tokens.LE; }
">"						{ yylval.Set((int)Tokens.GT);			return (int)Tokens.GT; }
">="					{ yylval.Set((int)Tokens.GE);			return (int)Tokens.GE; }
"&&"					{ yylval.Set((int)Tokens.AND);			return (int)Tokens.AND; }
"||"					{ yylval.Set((int)Tokens.OR);			return (int)Tokens.OR; }
"!"						{ yylval.Set((int)Tokens.NOT);			return (int)Tokens.NOT; }

"event"					{ yylval.Set((int)Tokens.EVENT);		return (int)Tokens.EVENT; }

"this"					{ yylval.Set((int)Tokens.THIS);			return (int)Tokens.THIS; }
"owner"					{ yylval.Set((int)Tokens.OWNER);		return (int)Tokens.OWNER; }
"scopes"				{ yylval.Set((int)Tokens.SCOPES);		return (int)Tokens.SCOPES; }
"elements"				{ yylval.Set((int)Tokens.ELEMENTS);		return (int)Tokens.ELEMENTS; }
"states"				{ yylval.Set((int)Tokens.STATES);		return (int)Tokens.STATES; }
"events"				{ yylval.Set((int)Tokens.EVENTS);		return (int)Tokens.EVENTS; }

"//".*					{ /*comment*/ }
{alphanum}				{ yylval.Set(yytext); return (int)Tokens.IDENTIFIER; }
{string}				{ yylval.Set(yytext.Substring(1, yytext.Length - 2)); return (int)Tokens.STRING; }
"..."					{ yylval.Set((int)Tokens.ELLIPSIS); return (int)Tokens.ELLIPSIS; }

{whitespace}			{ }
.						{ yyerror("Unexpected symbol: " + yytext); return yytext[0]; }

%%

public override void yyerror(string format, params object[] args)
{
	base.yyerror(format, args);
	string error = string.Format("error in <filename>({0},{1}): {2}", yyline, yycol, format);
	Console.WriteLine(error);
	Errors.Add(error);
}

private List<string> m_errors = new List<string>();
public List<string> Errors { get { return m_errors; } }