%{
	private IEventParseCallback m_callback = new NullEventParseCallback();
	public IEventParseCallback Callback { get { return m_callback; } set { m_callback = value; } }
%}

%using StatsDataSource.Parsing
%namespace StatsDataSource.Preprocessing
%parsertype EProcParser

%visibility public

%YYSTYPE Token

%start DefinitionList
%token IDENTIFIER ELLIPSIS
%token STRING FLOAT
%token EQ NE LS LE GT GE AND OR NOT
%token EVENT 
%token THIS OWNER 
%token SCOPES ELEMENTS STATES EVENTS

%left AND OR 
%left EQ NE
%left LS LE GT GE 
%right NOT


%%

DefinitionList			:	/*empty*/											{ }
						|	Definition											{ $$ = Callback.OnDefinitionList(null, $1.oVal); }
						|	DefinitionList Definition							{ $$ = Callback.OnDefinitionList($1.oVal, $2.oVal); }
						;

Definition				:	DefinitionHeader '{' ActionList '}'					{ $$ = Callback.OnDefinition($1, $3.oVal); }
						|	DefinitionHeader '{' error '}'						{ $$ = new Token(); Console.WriteLine("Recovering from error"); yyerrok(); }
						;

DefinitionHeader		:	DefinitionType IDENTIFIER							{ $$ = Callback.OnDefinitionHeader((Tokens)$1.iVal, $2.sVal); }
						;

DefinitionType			:	EVENT
						;
						
ActionList				:	/*empty*/
						|	Action												{ $$ = Callback.OnActionList(null, $1); }
						|	ActionList Action									{ $$ = Callback.OnActionList($1.oVal, $2); }
						;

Action					:	ActionTarget '=' Path ';'							{ $$ = Callback.OnAction($1, $3); }
						|	ELLIPSIS											{ $$ = Callback.OnAction((Tokens)$1.iVal); }
						;

ActionTarget			:	IDENTIFIER											{ $$ = Callback.OnActionTarget($1); }
						;
						
Path					:	PathElement											{ $$ = Callback.OnPath(null, $1); }
						|	Path '.' PathElement								{ $$ = Callback.OnPath($1.oVal, $3); }
						;
						
PathElement				:	IDENTIFIER											{ $$ = Callback.OnPathElement($1); }
						|	PathElemPDSingle									{ $$ = Callback.OnPathElement((Tokens)$1.iVal, null); }
						|	PathElemPDCollection CollectionSelectorList			{ $$ = Callback.OnPathElement((Tokens)$1.iVal, $2.oVal); }
						;
						
PathElemPDSingle		:	THIS | OWNER
						;
						
PathElemPDCollection	:	SCOPES | ELEMENTS | STATES | EVENTS
						;

CollectionSelectorList	:	CollectionSelector									{ $$ = Callback.OnCollectionSelectorList(null, $1.oVal); }
						|	CollectionSelectorList CollectionSelector			{ $$ = Callback.OnCollectionSelectorList($1.oVal, $2.oVal); }
						;
						
CollectionSelector		:	'[' SelectedTypeList ']'							{ $$ = Callback.OnCollectionSelector($2.oVal, null); }
						|	'[' SelectedTypeList ':' ConditionalExpr ']'		{ $$ = Callback.OnCollectionSelector($2.oVal, $4.oVal); }
						;


SelectedTypeList		:	SelectedType										{ $$ = Callback.OnSelectedTypeList(null, $1); }
						|	SelectedTypeList ',' SelectedType					{ $$ = Callback.OnSelectedTypeList($1.oVal, $3); }
						;
						
SelectedType			:	IDENTIFIER
						;
						
ConditionalExpr			:	Term												{ $$ = Callback.OnConditionalExpr($1); }
						|	ConditionalExpr RelOp Term							{ $$ = Callback.OnConditionalExpr($1, (Tokens)$2.iVal, $3); }
						;						
						
Term					:	Path
						|	Constant
						;
						
Constant				:	STRING
						|	FLOAT
						;
						
RelOp					:	EQ | NE | LS | LE | GT | GE | AND | OR | NOT
						;

%%

public EProcParser(EProcScanner scanner) : base(scanner) { }

public void SetError(string desc)
{
	Scanner.yyerror(desc);
	YYError();
}