﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using StatsDataSource.Parsing;

namespace StatsDataSource.Preprocessing
{
	/// <summary>
	/// Parsing callback which is called by semantic analyzer
	/// when some specific construction was encountered.
	/// </summary>
	public interface IEventParseCallback
	{
		Token OnDefinitionList(object list, object definition);
		Token OnDefinition(Token header, object actions);
		Token OnDefinitionHeader(Tokens type, string name);

		Token OnActionList(object list, Token action);
		Token OnAction(Tokens specialAction);
		Token OnAction(Token target, Token path);
		Token OnActionTarget(Token target);

		Token OnPath(object path, Token element);
		Token OnPathElement(Token name);
		Token OnPathElement(Tokens predefinedId, object selectorList);

		Token OnCollectionSelectorList(object list, object selector);
		Token OnCollectionSelector(object types, object condition);
		Token OnSelectedTypeList(object list, Token typeName);

		Token OnConditionalExpr(Token term);
		Token OnConditionalExpr(Token expr, Tokens relOp, Token term);
	}

	/// <summary>
	/// Empty implementation of parsing callback for testing purposes.
	/// </summary>
	class NullEventParseCallback : IEventParseCallback
	{
		public Token OnDefinitionList(object list, object definition) { return new Token(); }
		public Token OnDefinition(Token header, object actions) { return new Token(); }
		public Token OnDefinitionHeader(Tokens type, string name) { return new Token(); }

		public Token OnActionList(object list, Token action) { return new Token(); }
		public Token OnAction(Tokens specialAction) { return new Token(); }
		public Token OnAction(Token target, Token path) { return new Token(); }
		public Token OnActionTarget(Token target) { return new Token(); }

		public Token OnPath(object path, Token element) { return new Token(); }
		public Token OnPathElement(Token name) { return new Token(); }
		public Token OnPathElement(Tokens predefinedId, object selectorList) { return new Token(); }

		public Token OnCollectionSelectorList(object list, object selector) { return new Token(); }
		public Token OnCollectionSelector(object types, object condition) { return new Token(); }
		public Token OnSelectedTypeList(object list, Token typeName) { return new Token(); }

		public Token OnConditionalExpr(Token term) { return new Token(); }
		public Token OnConditionalExpr(Token expr, Tokens relOp, Token term) { return new Token(); }
	}
}


namespace StatsDataSource.DataAccumulation
{
	/// <summary>
	/// Parsing callback which is called by semantic analyzer
	/// when some specific construction was encountered.
	/// </summary>
	public interface IDataAccParseCallback
	{
		Token OnDefinitionList(object list, object definition);

		Token OnContextSet(Token name, object contextList);
		Token OnContextList(object list, object context);

		Token OnContext(object elements);
		Token OnContextElementList(object list, object element);
		Token OnContextElement(Token identifier, Token path);

		Token OnStatDef(Token name, Token cntset, object source, object operation);
		Token OnStatSource(Tokens operation, Token path);
		Token OnStatOperation(Tokens operation);

		Token OnPath(object path, Token element);
		Token OnPathElement(Token name);
		Token OnPathElement(Tokens predefinedId, object selectorList);

		Token OnCollectionSelectorList(object list, object selector);
		Token OnCollectionSelector(Token identifier);
	}

	/// <summary>
	/// Empty implementation of parsing callback for testing purposes.
	/// </summary>
	class NullDataAccParseCallback : IDataAccParseCallback
	{
		public Token OnDefinitionList(object list, object definition) { return new Token(); }

		public Token OnContextSet(Token name, object contextList) { return new Token(); }
		public Token OnContextList(object list, object context) { return new Token(); }

		public Token OnContext(object elements) { return new Token(); }
		public Token OnContextElementList(object list, object element) { return new Token(); }
		public Token OnContextElement(Token identifier, Token path) { return new Token(); }

		public Token OnStatDef(Token name, Token cntset, object source, object operation) { return new Token(); }
		public Token OnStatSource(Tokens operation, Token path) { return new Token(); }
		public Token OnStatOperation(Tokens operation) { return new Token(); }

		public Token OnPath(object path, Token element) { return new Token(); }
		public Token OnPathElement(Token name) { return new Token(); }
		public Token OnPathElement(Tokens predefinedId, object selectorList) { return new Token(); }

		public Token OnCollectionSelectorList(object list, object selector)  { return new Token(); }
		public Token OnCollectionSelector(Token identifier) { return new Token(); }
	}
}
