﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace StatsDataSource.Parsing
{
	public enum TokenType 
	{ 
		OBJECT,
		INT, 
		STRING, 
	}

	public struct Token
	{
		public Token(int i) : this()
		{
			m_iVal = i;
			Type = TokenType.INT;
		}

		public Token(string s) : this()
		{
			m_sVal = s;
			Type = TokenType.STRING;
		}

		public Token(object obj) : this()
		{
			m_oVal = obj;
			Type = TokenType.OBJECT;
		}

		public TokenType Type;

		private int m_iVal;
		public int iVal 
		{ 
			get { Debug.Assert(Type == TokenType.INT); return m_iVal; } 
			private set { m_iVal = value; } 
		}

		private string m_sVal;
		public string sVal 
		{ 
			get { Debug.Assert(Type == TokenType.STRING); return m_sVal; } 
			private set { m_sVal = value; } 
		}

		private object m_oVal;
		public object oVal 
		{ 
			get { Debug.Assert(Type == TokenType.OBJECT); return m_oVal; } 
			private set { m_oVal = value; } 
		}

		public void Set(int value) { Type = TokenType.INT; iVal = value; }
		public void Set(string value) { Type = TokenType.STRING; sVal = value; }
		public void Set(object value) { Type = TokenType.OBJECT; oVal = value; }
	}
}
