﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using StatsDataSource.Core;
using System.Xml;
using StatsDataSource.DataAccumulation;
using StatsDataSource.Preprocessing;
using StatsDataSource.Storage;

namespace StatsDataSource.Test
{
	class Program
	{
		static void PreportErrors(List<string> errors)
		{
			if (errors.Count != 0)
			{
				Console.WriteLine("\nErrors:");
				foreach (var e in errors)
					Console.WriteLine(e.Replace("<filename>", "grammar_test.txt"));

				Debug.Assert(errors.Count == 0);
			}
		}

		static void Main(string[] args)
		{
			{
				using (var fs = new FileStream("grammar_test.txt", FileMode.Open, FileAccess.Read))
				{
					var scanner = new EProcScanner(fs);
					var parser = new EProcParser(scanner);
					parser.Trace = true;
					parser.Parse();

					PreportErrors(scanner.Errors);
				}
			}

			Console.WriteLine("\n===========================================================\n");

			{
				List<string> errors;
				StatsCore core = new StatsCore("1.0.0.1", XmlReader.Create("test_format.xml"), "test_processing.txt", null, out errors);
				PreportErrors(errors);

				core.Repository.LoadFromXML(XmlReader.Create("test_data.xml"));

				core.Repository.SaveToXML("Result.xml");
			}

			Console.WriteLine("\n===========================================================\n");

			{
				using (var fs = new FileStream("data_acc_test.txt", FileMode.Open, FileAccess.Read))
				{
					var scanner = new DataAccScanner(fs);
					var parser = new DataAccParser(scanner);
					parser.Trace = true;
					parser.Parse();

					PreportErrors(scanner.Errors);
				}
			}

			Console.WriteLine("\n===========================================================\n");

			{
				List<string> errors;
				StatsCore core = new StatsCore("1.0.0.1", XmlReader.Create("test_format.xml"), null, "data_acc_test.txt", out errors);
				PreportErrors(errors);

				core.Repository.LoadFromXML(XmlReader.Create("test_data.xml"));

				List<DataUpdate> updates = new List<DataUpdate>();
				foreach (var s in core.Repository.RootScopes)
				{
					updates.AddRange( core.Repository.DataProcessor.FinalizeAccumulation(s) );
				}

				foreach (var upd in updates)
					Console.WriteLine("profileID = {0}, value = {1}, operation = {2}, context = {3}", upd.ProfileID, upd.Value, upd.DBOperation.ToString(), upd.Context);
			}
		}
	}
}
