﻿using System;
using System.Collections.Generic;
using System.Text;

namespace StatsDataSource.Core
{
	///////////////////////////////////////////////////////////////////

	public enum ECoreMessage
	{
		Idle,
	}

	///////////////////////////////////////////////////////////////////

	public enum EActionType
	{
		MenuAction,
	}

	///////////////////////////////////////////////////////////////////

	public interface IPluginAction
	{
		EActionType getType();

		string getName();

		bool CanExecute();

		bool IsEnabled();

		void Execute();
	}

	///////////////////////////////////////////////////////////////////

	public interface IStatsPlugin
	{
		string getName();

		IPluginAction[] getActions();

		int getUsedTagCount();

		void Start(StatsCore Core, IMainForm MainForm, int tagBias);

		void HandleCoreMessage(ECoreMessage msg);

		void Stop();
	}

	///////////////////////////////////////////////////////////////////

	public delegate void ActionDeleg(IPluginAction action);

	public class DelegAction : IPluginAction
	{
		public EActionType getType() { return EActionType.MenuAction; }
		
		string m_Name;
		public string getName() { return m_Name; }
		
		bool m_isEnabled;
		public bool IsEnabled() { return m_isEnabled; }
		public void setIsEnabled(bool e) { m_isEnabled = e; }
		
		bool m_canExecute;
		public bool CanExecute() { return m_canExecute; }
		public void SetCanExecute(bool c) { m_canExecute = c; }

		public void Execute()
		{
			if(m_canExecute)
				m_deleg(this);
			else
				throw new Exception("Trying to execute disabled action");
		}

		private ActionDeleg m_deleg;
		public DelegAction(string name, ActionDeleg deleg)
		{
			m_Name = name;
			m_deleg = deleg;
			m_canExecute = true;
			m_isEnabled = false;
		}
	}
}
