﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.DataAccumulation
{
	class StatProcSettings
	{
		public ContextBuilder[] Contexts;
		public string StatName;
		public string EventName;
		public DataPath SourcePath;
		public EOperationType ExtractOperation;
		public EOperationType DBOperation;

		public StatProcSettings(ContextBuilder[] Contexts, string StatName, string EventName,
			DataPath SourcePath, EOperationType ExtractOperation, EOperationType DBOperation)
		{
			this.Contexts = Contexts;
			this.StatName = StatName;
			this.EventName = EventName;
			this.SourcePath = SourcePath;
			this.ExtractOperation = ExtractOperation;
			this.DBOperation = DBOperation;
		}
	}

	class Accumulator
	{
		int m_currentPos;
		DataPath m_path;
		IOperation m_operation;
		public readonly StatProcSettings ProcessingSettings;

		public Accumulator(StatProcSettings settings)
		{
			ProcessingSettings = settings;
			m_currentPos = 0;
			m_path = settings.SourcePath;
			m_operation = IOperation.Create(settings.ExtractOperation);
		}

		public void Process(GameEventGroup evntGroup, int maxPos)
		{
			while (m_currentPos < evntGroup.Events.Count && m_currentPos <= maxPos)
			{
				GameEvent e = evntGroup.Events[m_currentPos];

				string val = m_path.GetValue(e);
				m_operation.Evaluate(val);

				++m_currentPos;
			}
		}

		public string GetResult()
		{
			return m_operation.GetResult();
		}
	}
}
