﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.DataAccumulation
{
	class ContextBuilder
	{
		public KeyValuePair<string, DataPath>[] Elements;

		public ContextBuilder(KeyValuePair<string, DataPath>[] elems)
		{
			Elements = elems;
		}

		public string GetContextName(GameElement player)
		{
			if (Elements == null || Elements.Length == 0)
				return "";

			StringBuilder sb = new StringBuilder(50 * Elements.Length);
			for (int i = 0; i != Elements.Length; ++i)
			{
				sb.Append('[');
				sb.Append(Elements[i].Key);
				sb.Append(']');
				sb.Append(Elements[i].Value.GetValue(player) ?? "");
			}
			return sb.ToString();
		}
	}
}
