﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.Filters
{
	[Serializable]
	public class CompoundANDFilter : CompoundFilter
	{
		public CompoundANDFilter()
		{
			Name = "AND";
			Enabled = true;
			SubFilters = new List<FilterBase>();
		}

		public override object Clone()
		{
			CompoundANDFilter ret = new CompoundANDFilter();
			ret.Enabled = Enabled;
			return ret;
		}

		public override EFilterState TestScope(GameScope scope)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			bool allUnaffected = true;
			foreach (FilterBase f in SubFilters)
			{
				if (f.Enabled)
				{
					EFilterState test = f.TestScope(scope);
					if (test == EFilterState.Failed) return EFilterState.Failed;
					else if (test == EFilterState.Passed) allUnaffected = false;
				}
			}

			return allUnaffected ? EFilterState.Unaffected : EFilterState.Passed;
		}

		public override EFilterState TestElement(GameElement element)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			bool allUnaffected = true;
			foreach (FilterBase f in SubFilters)
			{
				if (f.Enabled)
				{
					EFilterState test = f.TestElement(element);
					if (test == EFilterState.Failed) return EFilterState.Failed;
					else if (test == EFilterState.Passed) allUnaffected = false;
				}
			}

			return allUnaffected ? EFilterState.Unaffected : EFilterState.Passed;
		}

		public override EFilterState TestState(GameState state)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			bool allUnaffected = true;
			foreach (FilterBase f in SubFilters)
			{
				if (f.Enabled)
				{
					EFilterState test = f.TestState(state);
					if (test == EFilterState.Failed) return EFilterState.Failed;
					else if (test == EFilterState.Passed) allUnaffected = false;
				}
			}

			return allUnaffected ? EFilterState.Unaffected : EFilterState.Passed;
		}

		public override EFilterState TestEventGroup(GameEventGroup group)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			bool allUnaffected = true;
			foreach (FilterBase f in SubFilters)
			{
				if (f.Enabled)
				{
					EFilterState test = f.TestEventGroup(group);
					if (test == EFilterState.Failed) return EFilterState.Failed;
					else if (test == EFilterState.Passed) allUnaffected = false;
				}
			}

			return allUnaffected ? EFilterState.Unaffected : EFilterState.Passed;
		}

		public override EFilterState TestEvent(GameEvent evnt)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			bool allUnaffected = true;
			foreach (FilterBase f in SubFilters)
			{
				if (f.Enabled)
				{
					EFilterState test = f.TestEvent(evnt);
					if (test == EFilterState.Failed) return EFilterState.Failed;
					else if (test == EFilterState.Passed) allUnaffected = false;
				}
			}

			return allUnaffected ? EFilterState.Unaffected : EFilterState.Passed;
		}
	}
}
