﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.Filters
{
	[Serializable]
	public class CompoundNOTFilter : CompoundFilter
	{
		public CompoundNOTFilter()
		{
			MaxChildren = 1;
			Name = "NOT";
			Enabled = true;
			SubFilters = new List<FilterBase>();
		}

		public override object Clone()
		{
			CompoundNOTFilter ret = new CompoundNOTFilter();
			ret.Enabled = Enabled;
			return ret;
		}

		private EFilterState Invert(EFilterState s)
		{
			return (s == EFilterState.Passed)
				? EFilterState.Failed
				: (s == EFilterState.Failed)
					? EFilterState.Passed
					: EFilterState.Unaffected;
		}

		public override EFilterState TestScope(GameScope scope)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			EFilterState res = SubFilters[0].TestScope(scope);
			return Invert(res);
		}

		public override EFilterState TestElement(GameElement element)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			EFilterState res = SubFilters[0].TestElement(element);
			return Invert(res);
		}

		public override EFilterState TestState(GameState state)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			EFilterState res = SubFilters[0].TestState(state);
			return Invert(res);
		}

		public override EFilterState TestEventGroup(GameEventGroup group)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			EFilterState res = SubFilters[0].TestEventGroup(group);
			return Invert(res);
		}

		public override EFilterState TestEvent(GameEvent evnt)
		{
			if (!Enabled || SubFilters.Count == 0) return EFilterState.Unaffected;

			EFilterState res = SubFilters[0].TestEvent(evnt);
			return Invert(res);
		}
	}
}
