﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.Diagnostics;
using StatsDataSource.Storage;

namespace StatsDataSource.Filters
{
	//////////////////////////////////////////////////////////////////

	public enum ECompareOperation
	{
		Equal,
		NotEqual,
		Less,
		LessEqual,
		Greater,
		GreaterEqual,
		Contains,

		Unknown,
	}

	//////////////////////////////////////////////////////////////////

	[Serializable]
	public abstract class FilterBase : NullStatsFilter, ICloneable
	{
		[XmlAttribute("name")]
		public string Name { get { return m_name; } set { m_name = value; } }

		[XmlAttribute("enabled")]
		public bool Enabled { get { return m_enabled; } set { m_enabled = value; } }

		[XmlAttribute("tag")]
		public string Tag { get { return m_tag; } set { m_tag = value; } }

		[XmlIgnore()]
		private string m_name;
		[XmlIgnore()]
		private bool m_enabled = true;
		[XmlIgnore()]
		private string m_tag;
		[XmlIgnore()]
		public CompoundFilter Parent;

		public abstract object Clone();

		public override string ToString()
		{
			return string.Format("[{0}] Filter {1}", Tag ?? "-", Name);
		}
	}

	//////////////////////////////////////////////////////////////////

	[Serializable]
	public abstract class TerminalFilter : FilterBase
	{
	}

	//////////////////////////////////////////////////////////////////

	[Serializable]
	public abstract class CompoundFilter : FilterBase
	{
		[XmlArray("children")]
		[XmlArrayItem("filter")]
		public List<FilterBase> SubFilters { get { return m_subfilters; } set { m_subfilters = value; } }
		private List<FilterBase> m_subfilters;

		[XmlAttribute("max_subfilters")]
		public int MaxChildren { get { return m_maxchildren; } set { m_maxchildren = value; } }
		private int m_maxchildren;

		public CompoundFilter()
		{
			MaxChildren = int.MaxValue;
		}

		public bool IsFull()
		{
			return MaxChildren == SubFilters.Count;
		}

		public void AddChild(FilterBase f)
		{
			Debug.Assert(!IsFull());
			if (IsFull())
				return;

			SubFilters.Add(f);
			f.Parent = this;
		}

		public void RemoveChild(FilterBase f)
		{
			SubFilters.Remove(f);
			f.Parent = null;
		}

		public void ClearChildren()
		{
			foreach (FilterBase f in SubFilters)
				f.Parent = null;
			SubFilters.Clear();
		}

		public override string ToString()
		{
			return string.Format("{0}, sub-filters {1}", base.ToString(), m_subfilters == null ? "0" : m_subfilters.Count.ToString());
		}
	}

	//////////////////////////////////////////////////////////////////

}
