﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;

namespace StatsDataSource.ObjectModel
{
	public class GameElement : GameNode
	{
		public override string Name { get { return Desc.Name; } }
		public ElementDesc Desc { get { return m_desc; } }

		////////////////////////////////////////////////////////////

		internal GameElement(Locator loc, GameScope parent, ElementDesc desc, StatsRepository repo)
			: base(loc, parent, repo)
		{
			m_desc = desc;
		}

		public override void AcceptVisitor(IStatsVisitor visitor)
		{
			if (visitor.VisitElement(this))
			{
				VisitStates(visitor);
				VisitEvents(visitor);
			}
			visitor.LeaveElement(this);
		}

		public override void AcceptVisitorFiltered(IStatsVisitor visitor)
		{
			if (FilterState == EFilterState.Failed)
				return;

			if (visitor.VisitElement(this))
			{
				VisitStatesFiltered(visitor);
				VisitEventsFiltered(visitor);
			}
			visitor.LeaveElement(this);
		}

		////////////////////////////////////////////////////////////

		ElementDesc m_desc;
	}
}
