﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;

namespace StatsDataSource.ObjectModel
{
	public class GameEvent : Taggable
	{
		public readonly GameEventGroup Group;

		public readonly Int64 TimeMillisecs;

		public readonly TimeSpan Time;

		public SortedList<string, string> Parameters;

		public EFilterState FilterState;

		internal GameEvent(GameEventGroup group, Int64 time, KeyValuePair<string, string>[] parameters)
		{
			FilterState = EFilterState.Unaffected;
			Group = group;
			TimeMillisecs = time;
			Time = TimeSpan.FromMilliseconds(time);
			Parameters = new SortedList<string, string>();

			if (parameters != null)
				foreach (KeyValuePair<string,string> p in parameters)
					Parameters.Add(p.Key, p.Value);
		}
	}
}
