﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using System.Diagnostics;

namespace StatsDataSource.ObjectModel
{
	public class GameState : Taggable
	{
		private static int m_currentUnique = 0;
		public readonly int UniqueID;

		public readonly StatDesc Desc;

		public string Value;

		WeakReference m_node;
		public GameNode Node { get { return (GameNode)m_node.Target; } private set { m_node = new WeakReference(value); } }

		public readonly GameState Parent;

		public readonly int Depth;

		public EFilterState FilterState;

		public List<GameState> Children;

		internal GameState(StatDesc desc, string value, GameNode node, GameState parent)
		{
			Debug.Assert(desc != null);
			FilterState = EFilterState.Unaffected;
			UniqueID = ++m_currentUnique;
			Desc = desc;
			Value = value;
			Node = node;
			Parent = parent;
			Depth = parent == null ? (Node.Depth + 1) : (parent.Depth + 1);
			Children = new List<GameState>();
		}

		public GameState AddChild(StatDesc desc, string value)
		{
			GameState chld = new GameState(desc, value, Node, this);
			Children.Add(chld);
			Node.Repository.OnStateAdded(chld);
			return chld;
		}

		public void AcceptVisitor(IStatsVisitor visitor)
		{
			if (visitor.VisitState(this))
			{
				foreach (GameState s in Children)
					s.AcceptVisitor(visitor);
			}
			visitor.LeaveState(this);
		}

		public void AcceptVisitorFiltered(IStatsVisitor visitor)
		{
			if (visitor.VisitState(this))
			{
				foreach (GameState s in Children)
					s.AcceptVisitorFiltered(visitor);
			}
			visitor.LeaveState(this);
		}

		public override string ToString()
		{
			return Value;
		}
	}
}
