﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace StatsDataSource.ObjectModel
{
	public struct Locator
	{
		public readonly int ElementID;
		public readonly int ScopeID;
		public readonly int LocatorType;
		public readonly int LocatorValue;
		public readonly int TimeStamp;

		public Locator(int elemID, int scID, int locT, int locVal, int timeStmp)
		{
			ElementID = elemID;
			ScopeID = scID;
			LocatorType = locT;
			LocatorValue = locVal;
			TimeStamp = timeStmp;
		}

		public static Locator FromString(string s)
		{
			string[] its = s.Split(new char[] { '[', ',', ']' });
			Debug.Assert(its.Length == 7);

			int elemID = int.Parse(its[1]);
			int scID = int.Parse(its[2]);
			int locT = int.Parse(its[3]);
			int locVal = int.Parse(its[4]);
			int timeStmp = int.Parse(its[5]);

			return new Locator(elemID, scID, locT, locVal, timeStmp);
		}

		public override string ToString()
		{
			return string.Format("[{0},{1},{2},{3},{4}]", ElementID, ScopeID, LocatorType, LocatorValue, TimeStamp);
		}

		public static bool operator ==(Locator l1, Locator l2)
		{
			return l1.ElementID == l2.ElementID &&
							l1.ScopeID == l2.ScopeID &&
							l1.LocatorType == l2.LocatorType &&
							l1.LocatorValue == l2.LocatorValue &&
							l1.TimeStamp == l2.TimeStamp;
		}

		public static bool operator !=(Locator l1, Locator l2)
		{
			return !(l1 == l2);
		}

		public override bool Equals(object obj)
		{
			if (obj == null) return false;
			if (!(obj is Locator)) return false;
			Locator o = (Locator)obj;
			return this == o;
		}

		public override int GetHashCode()
		{
			return ElementID ^ ScopeID ^ LocatorType ^ LocatorValue ^ TimeStamp;
		}

		public bool IsScope()
		{
			return ElementID == -1;
		}

	}
}
