﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.Preprocessing
{
	/// <summary>
	/// Action objects are used concurrently
	/// by crawler for different instances of
	/// event groups, so it should be stateless.
	/// </summary>
	public interface ICrawlerAction
	{
		object Connect(CrawlerContext context, GameEventGroup group);

		void Execute(CrawlerContext context, object cachedConnection);
	}


	class CActionInsertAllOwn : ICrawlerAction
	{
		public object Connect(CrawlerContext context, GameEventGroup group)
		{
			return null;
		}

		public void Execute(CrawlerContext context, object cachedConnection)
		{
			SortedList<string,string> prms = context.Event.Parameters;
			foreach (KeyValuePair<string,string> p in prms)
				context.ProcessedParameters.Add(p.Key, p.Value);
		}
	}


	class CActionExtract : ICrawlerAction
	{
		string m_target;
		CrawlerPath m_path;

		public CActionExtract(string target, CrawlerPath path)
		{
			m_target = target;
			m_path = path;
		}

		public object Connect(CrawlerContext context, GameEventGroup group)
		{
			return m_path.Connect(context, group);
		}

		public void Execute(CrawlerContext context, object cachedConnection)
		{
			string value = m_path.FetchValue(context, cachedConnection);
			context.ProcessedParameters.Add(m_target, value ?? "");
		}
	}

}
