﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.Storage
{
	public enum EFilterUpdateType
	{
		Regular,
		Regular_Event,
		Fast_Event,
	}

	public enum EFilterState
	{
		Passed,
		Failed,
		Unaffected,
	}

	public interface IStatsFilter
	{
		EFilterState TestScope(GameScope scope);
		EFilterState TestElement(GameElement element);
		EFilterState TestState(GameState state);
		EFilterState TestEventGroup(GameEventGroup group);
		EFilterState TestEvent(GameEvent evnt);

		// Just a helper to differ between scopes and elements
		EFilterState TestNode(GameNode node);
	}

	public class NullStatsFilter : IStatsFilter
	{
		public virtual EFilterState TestScope(GameScope scope) { return EFilterState.Unaffected; }
		public virtual EFilterState TestElement(GameElement element) { return EFilterState.Unaffected; }
		public virtual EFilterState TestState(GameState state) { return EFilterState.Unaffected; }
		public virtual EFilterState TestEventGroup(GameEventGroup group) { return EFilterState.Unaffected; }
		public virtual EFilterState TestEvent(GameEvent evnt) { return EFilterState.Unaffected; }

		public EFilterState TestNode(GameNode node)
		{
			if (node.Locator.IsScope())
			{
				return TestScope((GameScope)node);
			}
			else
			{
				return TestElement((GameElement)node);
			}
		}
	}
}
