﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;
using StatsDataSource.Filters;

namespace StatsDataSource.Storage
{
	public interface IBatchListener
	{
		void ModificationBatchStarted();
		void ModificationBatchEnded(IncrementalUpdate update);
	}

	public interface IStatsListener : IBatchListener
	{
		void RepositoryNodeAdded(GameNode node);
		void RepositoryStateAdded(GameState state);
		void RepositoryEventGroupAdded(GameEventGroup group);
		void RepositoryEventAdded(GameEvent evnt);
	}

	public interface IFilteredStatsListener : IStatsListener
	{
		void RepositoryFilterChanged(CompoundFilter active, EFilterUpdateType type);
	}
}
