﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsDataSource.Storage
{
	public interface IStatsVisitor
	{
		bool VisitScope(GameScope scope);
		void LeaveScope(GameScope scope);

		bool VisitElement(GameElement elem);
		void LeaveElement(GameElement elem);

		bool VisitState(GameState state);
		void LeaveState(GameState state);

		bool StartEventGroups(GameNode node);
		bool VisitEventGroup(GameEventGroup evntGroup);
		void LeaveEventGroup(GameEventGroup evntGroup);
		void EndEventGroups(GameNode node);

		void VisitEvent(GameEvent evnt);
	}
}
