﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;
using System.Drawing;
using SlimDX;
using System.Diagnostics;

namespace StatsGameK01
{
	//////////////////////////////////////////////////////////////////////////

	public enum EEventArchType
	{
		Path,
		Marker,
		Marker_Deduced,

		Num
	}

	public enum EEventOwner
	{
		AI,
		Player,
		Player_AI_Team,

		Num
	}

	//////////////////////////////////////////////////////////////////////////

	public class PathData
	{
		public List<Vector3> Points;
		public List<GameEvent> Events;
		public EEventOwner Owner;

		public PathData(EEventOwner Owner)
		{
			Points = new List<Vector3>();
			Events = new List<GameEvent>();
			this.Owner = Owner;
		}
	}

	//////////////////////////////////////////////////////////////////////////

	public struct MarkerInfo
	{
		public GameEvent Event;
		public Vector2 PositionIS;
		public Vector2 PositionWS;
		public EEventOwner Owner;

		public MarkerInfo(GameEvent Event, Vector2 PositionIS, Vector2 PositionWS, EEventOwner Owner)
		{
			this.Event = Event;
			this.PositionIS = PositionIS;
			this.PositionWS = PositionWS;
			this.Owner = Owner;
		}
	}
	
	//////////////////////////////////////////////////////////////////////////
}
