﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Core;
using System.Windows.Forms;
using System.IO;
using SlimDX.Direct3D9;

namespace StatsGameK01
{
	//////////////////////////////////////////////////////////////////////////

	public interface IMiniMapPlugin : IStatsPlugin
	{
		IMiniMap[] GetCahcedMaps();

		IMiniMap ActiveMap { get; set; }

		IMiniMap LoadMap(string name, string path);

		IMiniMapRenderer Renderer { get; }
	}

	//////////////////////////////////////////////////////////////////////////

	public class MinimapPlugin : IMiniMapPlugin
	{

		#region IStatsPlugin

		public string getName() { return "Minimap"; }

		public int getUsedTagCount() { return Tags.COUNT; }

		public StatsCore Core;

		public IMainForm MainForm;

		public IPluginAction[] getActions() { return MinimapForm.FillActions(); }

		internal MinimapForm MinimapForm { get; set; }


		public void Start(StatsCore Core, IMainForm MainForm, int tagBias)
		{
			Tags.Init(tagBias);

			this.Core = Core;
			this.MainForm = MainForm;

			MinimapForm = new MinimapForm();
			MinimapForm.Plugin = this;
			MinimapForm.Show((Form)MainForm);
		}

		public void HandleCoreMessage(ECoreMessage msg)
		{
		}

		public void Stop()
		{
		}

		#endregion

		//////////////////////////////////////////////////////////////////////////

		#region IMiniMapPlugin

		public IMiniMapRenderer Renderer { get { return MinimapForm.Renderer; } }

		public IMiniMap[] GetCahcedMaps()
		{
			IMiniMap[] maps = new IMiniMap[cachedMaps.Count];

			int i = 0;
			foreach (var p in cachedMaps)
			{
				maps[i] = p.Value;
				++i;
			}

			return maps;
		}

		IMiniMap activeMap;
		public IMiniMap ActiveMap 
		{
			get { return activeMap; }
			set
			{
				if (value == activeMap)
					return;
				activeMap = value;
				MinimapForm.SetMap(activeMap);
			}
		}

		private Dictionary<string, MiniMap> cachedMaps = new Dictionary<string, MiniMap>();		

		public IMiniMap LoadMap(string name, string path)
		{
			if (cachedMaps.ContainsKey(name))
				return cachedMaps[name];

			var metadata = MapMetaData.Load(Path.Combine(path, Path.GetFileName(path)) + ".xml");

			if (metadata == null)
				return null;

			Texture tex = null;
			try
			{
				tex = Texture.FromFile(MinimapForm.Renderer.Device, Path.Combine(path, metadata.MinimapFile));
			}
			catch
			{
				return null;
			}

			MiniMap mm = new MiniMap(MinimapForm.Renderer, name, tex, metadata.Rect);
			cachedMaps.Add(name, mm);
			return mm;
		}

		#endregion

		//////////////////////////////////////////////////////////////////////////

	}

	static class Tags
	{
		public static int POSTION = -1;
		public static int MAP = -1;
		public static int MARKER = -1;

		public static int COUNT = 1;

		public static void Init(int bias)
		{
			POSTION = bias;
			MAP = bias;
			MARKER = bias;
		}
	}
}
