float2 sampleRatio;

texture texIntensity;
sampler2D sIntensity = sampler_state
{
	Texture	  = texIntensity;
    MipFilter = LINEAR;
    MagFilter = LINEAR;
    MinFilter = LINEAR;
};


texture texPalette;
sampler1D sPalette = sampler_state
{
	Texture	  = texPalette;
    MipFilter = LINEAR;
    MagFilter = LINEAR;
    MinFilter = LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};


struct VSInput
{ 
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct VSOutput
{
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct PSOutput
{
    float4 color    : COLOR0;
};




VSOutput vs_transform( VSInput IN)
{
	VSOutput OUT;
	
    OUT.position    = IN.position;
    OUT.tex0		= IN.tex0;
    
    return OUT;
}


PSOutput ps_rasterize( VSOutput IN )
{
	PSOutput OUT;
	
	float intensity = tex2D(sIntensity, IN.tex0).r;		
    OUT.color = tex1D(sPalette, intensity);
    
    return OUT;
}




technique tech_main
{
    pass p0
    {
        vertexshader = compile vs_2_0 vs_transform();
        pixelshader = compile ps_2_0 ps_rasterize();
        
        CullMode = None;
        ZEnable = false;
        ZWriteEnable = false;
        
        AlphaBlendEnable = true;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
    }
}
