matrix mWVP: WORLDVIEWPROJ;

texture texture0;

sampler2D texSampler0 = sampler_state
{
	Texture	  = texture0;
    MipFilter = LINEAR;
    MagFilter = LINEAR;
    MinFilter = LINEAR;
};

struct VSInput
{ 
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct VSOutput
{
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct PSOutput
{
    float4 color    : COLOR0;
};




VSOutput vs_transform( VSInput IN)
{
	VSOutput OUT;
	
    OUT.position    = mul(IN.position, mWVP);
    OUT.tex0		= IN.tex0;
    
    return OUT;
}




PSOutput ps_rasterize( VSOutput IN )
{
	PSOutput OUT;
    OUT.color = float4(tex2D(texSampler0, IN.tex0).rgb, 1.0f);
    return OUT;
}




technique tech_main
{
    pass p0
    {
        vertexshader = compile vs_2_0 vs_transform();
        pixelshader = compile ps_2_0 ps_rasterize();
        
        CullMode = None;
        ZEnable = false;
        ZWriteEnable = false;
    }
}
