float fSprite;
float fNumSprites;
float fScale;
float4 vPosition;
matrix mWVP: WORLDVIEWPROJ;


texture texture0;
sampler2D texSampler0 = sampler_state
{
	Texture	  = texture0;
    MipFilter = LINEAR;
    MagFilter = LINEAR;
    MinFilter = LINEAR;
};

struct VSInput
{ 
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct VSOutput
{
    float4 position	: POSITION0;
    float2 tex0		: TEXCOORD0;
};

struct PSOutput
{
    float4 color    : COLOR0;
};




VSOutput vs_transform( VSInput IN)
{
	VSOutput OUT;
	
	float4 pos = (IN.position / fScale) + vPosition;
	pos.w = 1;
    OUT.position = mul(pos, mWVP);
    
    float spriteStride = 1.0f / fNumSprites;
    OUT.tex0 = float2(spriteStride * fSprite + IN.tex0.x * spriteStride,  IN.tex0.y);
    
    return OUT;
}




PSOutput ps_rasterize( VSOutput IN )
{
	PSOutput OUT;
    OUT.color = tex2D(texSampler0, IN.tex0);
    return OUT;
}




technique tech_main
{
    pass p0
    {
        vertexshader = compile vs_2_0 vs_transform();
        pixelshader = compile ps_2_0 ps_rasterize();
        
        CullMode = None;
        ZEnable = false;
        ZWriteEnable = false;
        
        AlphaTestEnable = true;
        AlphaRef = 0x10;
        AlphaFunc = GreaterEqual;
    }
}
