float2 vPosition;
float fMaxDensity;
float fSplatDensity;
matrix mWVP: WORLDVIEWPROJ;

struct VSInput
{ 
    float4 position	: POSITION0;
    float  intensity : TEXCOORD0;
};

struct VSOutput
{
    float4 position	: POSITION0;
    float  intensity : TEXCOORD0;
};

struct PSOutput
{
    float4 color    : COLOR0;
};




VSOutput vs_transform( VSInput IN)
{
	VSOutput OUT;
	
	float4 pos = IN.position + float4(vPosition, 0, 0);
	pos.w = 1;
    OUT.position = mul(pos, mWVP);
	OUT.intensity = IN.intensity;
    
    return OUT;
}




PSOutput ps_rasterize( VSOutput IN )
{
	PSOutput OUT;
    OUT.color = float4(IN.intensity * (fSplatDensity / fMaxDensity), 0, 0, 0);
    return OUT;
}




technique tech_main
{
    pass p0
    {
        vertexshader = compile vs_2_0 vs_transform();
        pixelshader = compile ps_2_0 ps_rasterize();
        
        CullMode = None;
        ZEnable = false;
        ZWriteEnable = false;
        
        AlphaBlendEnable = true;
        SrcBlend = One;
        DestBlend = One;
    }
}
