﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using System.Diagnostics;

namespace StatsGameK01
{
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	class FilteredTreeSynchronizer
	{
		IMiniMapView m_map;

		public FilteredTreeSynchronizer(IMiniMapView map)
		{
			m_map = map;
		}

		public void Synchronize()
		{
			Traverse(m_map.FullQTree.Root, m_map.FilteredQTree.Root);
			UpdatePaths();
			m_map.ClearFilteredBatch();
		}

		void Traverse(QuadNode<MarkerInfo> src, QuadNode<MarkerInfo> dest)
		{
			Debug.Assert(dest.Type == src.Type);

			if (src.Type == EQTreeNodeType.Section)
			{
				var s = (QuadSectionNode<MarkerInfo>)src;
				var d = (QuadSectionNode<MarkerInfo>)dest;

				bool e1 = s.isEmpty();
				bool e2 = d.isEmpty();

				if (e1)
				{
					Debug.Assert(e2);
					return;
				}

				if (e2)
					d.Split(m_map.FilteredQTree.TerminalSize);

				for (int i = 0; i != 4; ++i)
					Traverse(s.Quaters[i], d.Quaters[i]);
			}
			else
			{
				var s = (QuadTerminalNode<MarkerInfo>)src;
				var d = (QuadTerminalNode<MarkerInfo>)dest;

				d.Items.Clear();

				foreach (var it in s.Items)
					if (it.Event.FilterState != EFilterState.Failed)
						d.Items.Add(it);
			}
		}

		private void UpdatePaths()
		{
			m_map.FilteredPaths.Clear();

			foreach (var pair in m_map.FullPaths)
			{
				var p = pair.Value;

				if (p.Points.Count < 2)
					continue;

				if (p.Events[0].Group.FilterState == EFilterState.Failed)
					continue;

				var path = new PathData(p.Owner);

				for (int i = 0; i != p.Points.Count; ++i)
				{
					if (p.Events[i].FilterState != EFilterState.Failed)
					{
						path.Points.Add(p.Points[i]);
						path.Events.Add(p.Events[i]);
					}
				}

				if (path.Events.Count > 1)
					m_map.FilteredPaths.Add(pair.Key, path);
			}
		}

	}

}
