﻿using System;
using System.Collections.Generic;
using System.Text;
using SlimDX.Direct3D9;
using System.Runtime.InteropServices;
using SlimDX;

namespace StatsGameK01
{
	////////////////////////////////////////////////////////////////////////////

	struct MapVertex
	{
		public Vector3 Position;
		public Vector2 Texcoodrs;

		public MapVertex(Vector3 pos, Vector2 tex0)
		{
			Position = pos;
			Texcoodrs = tex0;
		}

		public static int Size { get { return Marshal.SizeOf(typeof(MapVertex)); } }

		private static VertexDeclaration s_declaration;
		public static VertexDeclaration GetDeclaration(Device d)
		{
			if (s_declaration == null)
			{
				VertexElement[] elements = new VertexElement[]
				{
						new VertexElement(0, 0, DeclarationType.Float3, DeclarationMethod.Default, DeclarationUsage.Position, 0),
						new VertexElement(0, 12, DeclarationType.Float2, DeclarationMethod.Default, DeclarationUsage.TextureCoordinate, 0),
						VertexElement.VertexDeclarationEnd
				};
				s_declaration = new VertexDeclaration(d, elements);
			}
			return s_declaration;
		}
	}

	////////////////////////////////////////////////////////////////////////////

	struct MarkerVertex
	{
		public Vector3 Position;
		public Vector2 Texcoord;

		public MarkerVertex(Vector3 pos, Vector2 tex)
		{
			Position = pos;
			Texcoord = tex;
		}

		public static int Size { get { return Marshal.SizeOf(typeof(MarkerVertex)); } }

		private static VertexDeclaration s_declaration;
		public static VertexDeclaration GetDeclaration(Device d)
		{
			if (s_declaration == null)
			{
				VertexElement[] elements = new VertexElement[]
				{
						new VertexElement(0, 0, DeclarationType.Float3, DeclarationMethod.Default, DeclarationUsage.Position, 0),
						new VertexElement(0, 12, DeclarationType.Float2, DeclarationMethod.Default, DeclarationUsage.TextureCoordinate, 0),
						VertexElement.VertexDeclarationEnd
				};
				s_declaration = new VertexDeclaration(d, elements);
			}
			return s_declaration;
		}
	}

	////////////////////////////////////////////////////////////////////////////

	struct SplatVertex
	{
		public Vector3 Position;
		public float Intensity;

		public SplatVertex(Vector3 pos, float intensity)
		{
			Position = pos;
			Intensity = intensity;
		}

		public static int Size { get { return Marshal.SizeOf(typeof(SplatVertex)); } }

		private static VertexDeclaration s_declaration;
		public static VertexDeclaration GetDeclaration(Device d)
		{
			if (s_declaration == null)
			{
				VertexElement[] elements = new VertexElement[]
				{
						new VertexElement(0, 0, DeclarationType.Float3, DeclarationMethod.Default, DeclarationUsage.Position, 0),
						new VertexElement(0, 12, DeclarationType.Float1, DeclarationMethod.Default, DeclarationUsage.TextureCoordinate, 0),
						VertexElement.VertexDeclarationEnd
				};
				s_declaration = new VertexDeclaration(d, elements);
			}
			return s_declaration;
		}
	}


	////////////////////////////////////////////////////////////////////////////

	public struct QuadVertex
	{
		public Vector4 Position;
		public Vector2 Texcoord;

		public QuadVertex(Vector4 pos, Vector2 tex)
		{
			Position = pos;
			Texcoord = tex;
		}

		public static int Size { get { return Marshal.SizeOf(typeof(QuadVertex)); } }

		private static VertexDeclaration s_declaration;
		public static VertexDeclaration GetDeclaration(Device d)
		{
			if (s_declaration == null)
			{
				VertexElement[] elements = new VertexElement[]
				{
						new VertexElement(0, 0, DeclarationType.Float4, DeclarationMethod.Default, DeclarationUsage.PositionTransformed, 0),
						new VertexElement(0, 16, DeclarationType.Float2, DeclarationMethod.Default, DeclarationUsage.TextureCoordinate, 0),
						VertexElement.VertexDeclarationEnd
				};
				s_declaration = new VertexDeclaration(d, elements);
			}
			return s_declaration;
		}
	}

	////////////////////////////////////////////////////////////////////////////
}
