﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;

namespace StatsStreaming.Messages
{
	class EventEntry
	{
		public Int64 time;
		public KeyValuePair<string, string>[] parameters;

		public EventEntry(Int64 t, KeyValuePair<string, string>[] p)
		{
			time = t;
			parameters = p;
		}
	}

	class GroupEnry
	{
		public string name;
		public List<EventEntry> events = new List<EventEntry>();

		public GroupEnry(string Name)
		{
			name = Name;
		}
	}

	class EventMessage : Message
	{
		public List<GroupEnry> EventGroups = new List<GroupEnry>();

		public override void Deliver(MessageQueue queue)
		{
			foreach (var g in EventGroups)
			{
				StatDesc desc = queue.Repository.Registry.GetEventDesc(g.name);
				if (desc == null)
					desc = queue.Repository.Registry.RegisterEvent(g.name);

				GameEventGroup egr = queue.CurrentNode.FindEventGroup(desc);
				if (egr == null)
					egr = queue.CurrentNode.AddEventGroup(desc);

				foreach (var e in g.events)
					egr.AddEvent(e.time, e.parameters);
			}
		}
	}

}
