﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsStreaming.Messages;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;

namespace StatsStreaming
{
	public class MessageQueue
	{
		public StatsRepository Repository { get; private set; }
		internal GameNode CurrentNode { get; set; }

		public delegate void QueueUpdatedDeleg();
		public event QueueUpdatedDeleg QueueUpdated;

		public MessageQueue(StatsRepository repo)
		{
			Repository = repo;
		}

		public void Enqueue(Message msg)
		{
			lock (m_queue)
			{
				m_queue.Enqueue(msg);
			}

			if (QueueUpdated != null)
				QueueUpdated();
		}

		public void DeliverAll()
		{
			Message[] msgs;
			lock (m_queue)
			{
				msgs = m_queue.ToArray();
				m_queue.Clear();
			}

			foreach (var m in msgs)
				m.Deliver(this);
		}

		public bool Empty
		{
			get
			{
				lock (m_queue)
				{
					return m_queue.Count == 0;
				}
			}
		}

		private Queue<Message> m_queue = new Queue<Message>();
	}
}
