﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;
using StatsDataSource.Storage;
using System.Diagnostics;

namespace StatsStreaming.Messages
{
	class NavigationMessage : Message
	{
		public enum EOperation
		{
			eOP_Push,
			eOP_Pop,
		}

		Locator loc;
		EOperation op;

		public NavigationMessage(EOperation operation, Locator loc)
		{
			op = operation;
			this.loc = loc;
		}

		public override void Deliver(MessageQueue queue)
		{
			if (op == EOperation.eOP_Push)
			{
				if (queue.CurrentNode == null)
				{
					queue.Repository.StartModificationBatch(true);

					queue.CurrentNode = queue.Repository.FindNode(loc);
					if (queue.CurrentNode == null)
						queue.CurrentNode = queue.Repository.AddRootScope(loc);
				}
				else
				{
					GameScope scope = (GameScope)queue.CurrentNode;
					GameNode n = scope.FindChild(loc);
					if (n == null)
						n = scope.AddChild(loc);
					queue.CurrentNode = n;
				}
			}
			else
			{
				Debug.Assert(queue.CurrentNode.Locator == loc);
				queue.CurrentNode = queue.CurrentNode.Parent;
				if(queue.CurrentNode == null)
					queue.Repository.EndModificationBatch();
			}
		}
	}
}
