﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;
using StatsDataSource.Storage;

namespace StatsStreaming.Messages
{
	class StateEntry
	{
		public string name;
		public string value;
		public List<StateEntry> children;

		public StateEntry(string n, string v)
		{
			name = n;
			value = v;
			children = new List<StateEntry>();
		}
	}

	class StateMessage : Message
	{
		public List<StateEntry> States = new List<StateEntry>();

		public override void Deliver(MessageQueue queue)
		{
			foreach (var e in States)
				TraverseStates(queue.Repository.Registry, queue.CurrentNode, null, e);
		}

		private void TraverseStates(StatsRegistry reg, GameNode node, GameState state, StateEntry ent)
		{
			StatDesc desc = reg.GetStateDesc(ent.name);
			if (desc == null)
				desc = reg.RegisterState(ent.name);

			GameState newState;

			newState = (state == null)
					? node.AddState(desc, ent.value)
					: state.AddChild(desc, ent.value);

			foreach (var c in ent.children)
				TraverseStates(reg, node, newState, c);
		}
	}
}
