﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using Microsoft.Win32.SafeHandles;

namespace StatsStreaming
{
	static class PipesWinAPI
	{
		public enum AccessMode : uint
		{
			GENERIC_READ = 0x80000000,
		}

		public enum CreationDisposition : uint
		{
			OPEN_EXISTING = 3,
		}

		[Flags]
		public enum PipeOpenModeFlags : uint
		{
			PIPE_ACCESS_DUPLEX = 0x00000003,
			PIPE_ACCESS_INBOUND = 0x00000001,
			PIPE_ACCESS_OUTBOUND = 0x00000002,
			FILE_FLAG_FIRST_PIPE_INSTANCE = 0x00080000,
			FILE_FLAG_WRITE_THROUGH = 0x80000000,
			FILE_FLAG_OVERLAPPED = 0x40000000,
			WRITE_DAC = 0x00040000,
			WRITE_OWNER = 0x00080000,
			ACCESS_SYSTEM_SECURITY = 0x01000000
		}

		[Flags]
		public enum ErrorCodes : int
		{
			ERROR_PIPE_CONNECTED = 535,
		}

		[Flags]
		public enum PipeModeFlags : uint
		{
			//One of the following type modes can be specified. The same type mode must be specified for each instance of the pipe.
			PIPE_TYPE_BYTE = 0x00000000,
			PIPE_TYPE_MESSAGE = 0x00000004,
			//One of the following read modes can be specified. Different instances of the same pipe can specify different read modes
			PIPE_READMODE_BYTE = 0x00000000,
			PIPE_READMODE_MESSAGE = 0x00000002,
			//One of the following wait modes can be specified. Different instances of the same pipe can specify different wait modes.
			PIPE_WAIT = 0x00000000,
			PIPE_NOWAIT = 0x00000001,
			//One of the following remote-client modes can be specified. Different instances of the same pipe can specify different remote-client modes.
			PIPE_ACCEPT_REMOTE_CLIENTS = 0x00000000,
			PIPE_REJECT_REMOTE_CLIENTS = 0x00000008
		}

		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern SafeFileHandle CreateNamedPipe(
			string lpName, 
			uint dwOpenMode,
			uint dwPipeMode, 
			uint nMaxInstances, 
			uint nOutBufferSize, 
			uint nInBufferSize,
			uint nDefaultTimeOut, 
			IntPtr lpSecurityAttributes);

		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern bool SetNamedPipeHandleState(
			SafeFileHandle hNamedPipe, 
			ref uint lpMode, 
			IntPtr lpMaxCollectionCount, 
			IntPtr lpCollectDataTimeout);

		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern bool ConnectNamedPipe(
			SafeFileHandle hPipe,
			IntPtr lpOverlapped);

		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern SafeFileHandle CreateFile(
			 string pipeName,
			 uint dwDesiredAccess,
			 uint dwShareMode,
			 IntPtr lpSecurityAttributes,
			 uint dwCreationDisposition,
			 uint dwFlagsAndAttributes,
			 IntPtr hTemplate);


		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern int WaitNamedPipe(
				string lpNamedPipeName,
				uint nTimeOut);
	}
}
