﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.ObjectModel;
using System.Diagnostics;

namespace StatsStreaming
{
	class MessageSerializer
	{
		private enum OpCode
		{
			eOC_Begin = 0,
			eOC_End = 1,
			eOC_Enter = 2,
			eOC_Leave = 3,
			eOC_Timeline = 4,
			eOC_Event = 5,

			eOC_Unknown = 255,
		}


		PipeServer m_pipe;

		public MessageSerializer(PipeServer pipe)
		{
			m_pipe = pipe;
		}

		public void BeginSending()
		{
			m_pipe.SendMsg("{" + (int)OpCode.eOC_Begin + "}");
		}

		public void EndSending()
		{
			m_pipe.SendMsg("{" + (int)OpCode.eOC_End + "}");
		}

		public void EnterNode(GameNode node)
		{
			StringBuilder sb = new StringBuilder(300);
			sb.Append("{" + (int)OpCode.eOC_Enter + "}[" + node.Name + "]");

			foreach (var kv in node.States)
			{
				if (kv.Value.Value != null)
				{
					Debug.Assert(kv.Value.Desc.Name.IndexOfAny(new char[] { ';', '=' }) == -1);
					Debug.Assert(kv.Value.Value.IndexOfAny(new char[] { ';', '=' }) == -1);
					sb.Append(kv.Value.Desc.Name + '=' + kv.Value.Value + ';');
				}
			}
			m_pipe.SendMsg(sb.ToString());
		}

		public void LeaveNode()
		{
			m_pipe.SendMsg( "{" + (int)OpCode.eOC_Leave + "}" );
		}

		public void SendTimeline(GameEventGroup group)
		{
			if (group.Events.Count == 0) 
				return;

			m_pipe.SendMsg( "{" + (int)OpCode.eOC_Timeline + "}" + group.Desc.Name );
		}

		public void SendEvent(GameEvent e)
		{
			StringBuilder sb = new StringBuilder(300);
			sb.Append("{" + (int)OpCode.eOC_Event + "}[" + e.TimeMillisecs + "]");

			foreach (var kv in e.Parameters)
			{
				Debug.Assert(kv.Key.IndexOfAny(new char[] { ';', '=' }) == -1);
				Debug.Assert(kv.Value.IndexOfAny(new char[] { ';', '=' }) == -1);
				sb.Append(kv.Key + '=' + kv.Value + ';');
			}

			m_pipe.SendMsg(sb.ToString());
		}
	}
}
