﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Win32.SafeHandles;
using System.IO;
using System.Runtime.InteropServices;

namespace StatsStreaming
{
	public class PipeServer
	{
		public bool IsOpened { get { return m_pipe != null && !m_pipe.IsClosed && !m_pipe.IsInvalid; } }

		public bool HasClient { get { return m_hasClient; } }


		public void OpenConnection(string pipeName, uint bufferSize)
		{
			m_pipename = pipeName;

			m_pipe = PipesWinAPI.CreateNamedPipe(
				m_pipename,
				(uint)PipesWinAPI.PipeOpenModeFlags.PIPE_ACCESS_OUTBOUND,
				(uint)PipesWinAPI.PipeModeFlags.PIPE_WAIT,
				1,
				bufferSize,
				0,
				0,
				IntPtr.Zero);

			if (m_pipe.IsInvalid)
				throw new Exception("Failed to create pipe");

			m_stream = new FileStream(m_pipe, FileAccess.Write, (int)bufferSize, false);
		}

		public void CloseConnection()
		{
			m_stream.Close();
			m_pipe.Close();
			m_hasClient = false;
		}

		public bool TryConnectClient()
		{
			uint mode = (uint)PipesWinAPI.PipeModeFlags.PIPE_NOWAIT;
			PipesWinAPI.SetNamedPipeHandleState(m_pipe, ref mode, IntPtr.Zero, IntPtr.Zero);

			PipesWinAPI.ConnectNamedPipe(m_pipe, IntPtr.Zero);
			bool connected = Marshal.GetLastWin32Error() == (int)PipesWinAPI.ErrorCodes.ERROR_PIPE_CONNECTED;

			mode = (uint)PipesWinAPI.PipeModeFlags.PIPE_WAIT;
			PipesWinAPI.SetNamedPipeHandleState(m_pipe, ref mode, IntPtr.Zero, IntPtr.Zero);

			m_hasClient = connected;

			return connected;
		}

		public void SendMsg(string msg)
		{
			byte[] header = BitConverter.GetBytes(msg.Length);
			byte[] message = Encoding.ASCII.GetBytes(msg);

			m_stream.Write(header, 0, header.Length);
			m_stream.Write(message, 0, message.Length);
		}

		public void Flush()
		{
			m_stream.Flush();
		}

		bool m_hasClient = false;
		private string m_pipename;
		private SafeFileHandle m_pipe;
		private FileStream m_stream;
	}
}
