﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Core;
using System.Windows.Forms;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;
using StatsDataSource.Filters;

namespace StatsStreaming.SandboxComm
{
	public class StreamingPlugin : IStatsPlugin, IFilteredStatsListener
	{
		//////////////////////////////////////////////////////////////////////////

		#region IStatsPlugin

		public string getName() { return "Sandbox communication plug-in"; }

		public int getUsedTagCount() { return 0; }

		public StatsCore Core;

		public IMainForm MainForm;

		public IPluginAction[] getActions() { return new IPluginAction[] { m_connectAction }; }

		public void Start(StatsCore Core, IMainForm MainForm, int tagBias)
		{
			this.Core = Core;
			this.MainForm = MainForm;
			Core.Repository.RegisterFilteredListener(this);
			m_connectAction = new DelegAction("&Actions/&Sandbox data exchange", Connect);

			if (Array.Find<string>(Core.CmdArgs, x => x == "--sandbox_connect") != null)
				m_connectAction.Execute();
		}

		public void HandleCoreMessage(ECoreMessage msg)
		{
		}

		public void Stop()
		{
		}

		DelegAction m_connectAction;

		#endregion

		//////////////////////////////////////////////////////////////////////////

		#region Actions

		PipeServer m_pipe;
		MessageSerializer m_serializer;

		private void Connect(IPluginAction action)
		{
			if (m_pipe == null)
				m_pipe = new PipeServer();

			try
			{
				if (!m_pipe.IsOpened)
				{
					m_pipe.OpenConnection("\\\\.\\pipe\\CryStatsToolPipe_" + Core.Build, 500 * 1024);
					m_serializer = new MessageSerializer(m_pipe);
					SendData();
				}
				else
				{
					m_pipe.CloseConnection();
					m_serializer = null;
				}
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}

			m_connectAction.setIsEnabled(m_pipe.IsOpened);
		}

		#endregion


		//////////////////////////////////////////////////////////////////////////


		#region IStatsListener Members

		void SendData()
		{
			if (m_pipe == null || !m_pipe.IsOpened)
				return;

			if (!m_pipe.HasClient)
				m_pipe.TryConnectClient();

			if (m_pipe.HasClient)
			{
				var v = new StreamingVisitor(m_serializer);

				m_serializer.BeginSending();
				Core.Repository.AcceptVisitorFiltered(v);
				m_serializer.EndSending();

				m_pipe.Flush();
			}
		}

		public void RepositoryFilterChanged(CompoundFilter active, EFilterUpdateType type)
		{
			if(type != EFilterUpdateType.Fast_Event)
				SendData();
		}

		public void ModificationBatchStarted() { }

		public void ModificationBatchEnded(IncrementalUpdate update)
		{
			SendData();
		}

		public void RepositoryNodeAdded(GameNode node) { }
		public void RepositoryStateAdded(GameState state) { }
		public void RepositoryEventGroupAdded(GameEventGroup group) { }
		public void RepositoryEventAdded(GameEvent evnt) { }

		#endregion

		//////////////////////////////////////////////////////////////////////////
	}
}
