﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;

namespace StatsStreaming
{
	class StreamingVisitor : IStatsVisitor
	{
		MessageSerializer m_serializer;

		public StreamingVisitor(MessageSerializer serializer)
		{
			m_serializer = serializer;
		}

		public bool VisitScope(GameScope scope)
		{	
			m_serializer.EnterNode(scope);
			return true;
		}

		public void LeaveScope(GameScope scope)
		{
			m_serializer.LeaveNode();
		}

		public bool VisitElement(GameElement elem)
		{
			m_serializer.EnterNode(elem);
			return true;
		}

		public void LeaveElement(GameElement elem)
		{
			m_serializer.LeaveNode();
		}

		public bool VisitState(GameState state) { return false; }
		public void LeaveState(GameState state) { }
		public bool StartEventGroups(GameNode node) { return true; }
		
		public bool VisitEventGroup(GameEventGroup evntGroup) 
		{
			m_serializer.SendTimeline(evntGroup);
			return true;
		}

		public void LeaveEventGroup(GameEventGroup evntGroup) { }
		public void EndEventGroups(GameNode node) { }
		public void VisitEvent(GameEvent evnt) 
		{
			m_serializer.SendEvent(evnt);
		}
	}
}
