using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace StatsTool
{
	public class CategoryFilter
	{
		private bool[] m_mask;
		private List<string> m_allCategories;

		public void Init(IList<string> categories)
		{
			m_allCategories = categories as List<string>;//cant use Sort with IList
			if (m_allCategories == null)
				return;

			m_mask = new bool[categories.Count];
		}

		public void SetAllFlags(bool status)
		{
			for(int i = 0; i < m_mask.Length; ++i)
				m_mask[i] = status;
		}

		public bool SetAllAndReportChanges(bool status)
		{
			bool[] oldMask = m_mask.Clone() as bool[];
			SetAllFlags(status);

			bool equalValues = true;
			for (int i = 0; i < m_mask.Length; ++i)
				equalValues = equalValues && ( m_mask[i] == oldMask[i] );

			return !equalValues;
		}

		private bool IsValidIdx(int idx)
		{
			if (idx < 0 || idx >= m_mask.Length)
				return false;

			return true;
		}

		public void SetFlag(int idx, bool status)
		{
			if (IsValidIdx(idx))
				m_mask[idx] = status;
		}

		public bool IsChangingState(int idx, bool status)
		{
			if (IsValidIdx(idx))
				return m_mask[idx] != status;
			return false;
		}

		public bool SetIfChangingState(int idx, bool status)
		{
			if (IsChangingState(idx, status))
			{
				SetFlag(idx, status);
				return true;
			}
			return false;
		}

		public bool GetFlag(string categoryStr)
		{
			int idx = m_allCategories.IndexOf(categoryStr);
			if (idx != -1)
				return m_mask[idx];
			else
				return false;
		}

		public IList<string> GetFiltered()
		{
			IList<string> res = new List<string>();
			
			int i = 0;
			foreach (string s in m_allCategories)
			{
				if (m_mask[i])
					res.Add(s);
			
				++i;
			}
			return res;
		}
	}
}
