using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using StatsTool.Properties;

namespace StatsTool.Dialogs
{
    public partial class Options : Form
    {
        public Options()
        {
            InitializeComponent();
            tbPath.Text = Settings.Default.GamePath;
            FillColorBox(cbTeam1color);
            FillColorBox(cbTeam2color);
            if (Settings.Default.Team1Color != string.Empty)
            {
                cbTeam1color.SelectedItem = Settings.Default.Team1Color;
            }
            if (Settings.Default.Team2Color != string.Empty)
            {
                cbTeam2color.SelectedItem = Settings.Default.Team2Color;
            }
        }

        private void FillColorBox(ComboBox cb)
        {
            string[] elems = Enum.GetNames(typeof(KnownColor));
            foreach(string name in elems)
            {
                int idx = cb.Items.Add(name);
            }
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Settings.Default.GamePath = tbPath.Text;
            Settings.Default.Team1Color = cbTeam1color.Text;
            Settings.Default.Team2Color = cbTeam2color.Text;
            Settings.Default.Save();
            this.Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if(bffd.ShowDialog(this) == DialogResult.OK)
            {
                tbPath.Text = bffd.SelectedPath;
            }
        }

        private void ColorBox_DrawItem(object sender, DrawItemEventArgs e)
        {
            Graphics g = e.Graphics;
            Color c = Color.FromName((string)((sender as ComboBox).Items[e.Index]));
            g.FillRectangle(new SolidBrush(c), e.Bounds);
            e.DrawFocusRectangle();
        }
    }
}