using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Microsoft.VisualBasic.Devices;

namespace StatsTool
{
	public class CDoubleTrackBar
	{
		const int MIN_TRACK_DIST = 1;

		//public methods
		public CDoubleTrackBar(
														TrackBar tbrBegin,
														TrackBar tbrEnd,
														TextBox	tbxBegin,
														TextBox	tbxEnd,
														TextBox	tbxLongest,
														CheckBox cbPreserve,
														SharedData sharedData,
														UpdateDelegate updateDelegate
													)
		{
			m_tbrBegin				= tbrBegin;
			m_tbrEnd					= tbrEnd;
			m_tbxBegin				= tbxBegin;
			m_tbxEnd					= tbxEnd;
			m_tbxLongest			= tbxLongest;
			m_cbPreserve			= cbPreserve;
			m_sharedData			= sharedData;
			m_updateDelegate	= updateDelegate;

			tbrBegin.Value = tbrBegin.Minimum;
			tbrEnd.Value = tbrEnd.Maximum;

			m_sharedData.m_longestRoundTime = m_sharedData.m_drawMan.GetLongestRoundTime();

			tbxBegin.Text = "00:00:00";
			tbxEnd.Text = m_sharedData.m_longestRoundTime.ToString().Split('.')[0];
			tbxLongest.Text = tbxEnd.Text;

			OnTbrBeginValueChanged();
			OnTbrEndValueChanged();
		}

		public void OnTbrBeginValueChanged()
		{
			OnTbrValueChanged(m_tbrBegin, m_tbrEnd, m_tbxBegin, ref m_sharedData.m_timeFilterData.m_begin, ref m_oldTimeFilterVals[0]);
		}

		public void OnTbrEndValueChanged()
		{
			OnTbrValueChanged(m_tbrEnd, m_tbrBegin, m_tbxEnd, ref m_sharedData.m_timeFilterData.m_end, ref m_oldTimeFilterVals[1]);
		}

		public void OnTbxBeginEnterPressed(KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				OnTbxEnterPressed(m_tbxBegin, m_tbrBegin, new TimeSpan(0));
				OnTbrBeginValueChanged();
			}
		}

		public void OnTbxEndEnterPressed(KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter)
			{
				OnTbxEnterPressed(m_tbxEnd, m_tbrEnd, m_sharedData.m_longestRoundTime);
				OnTbrEndValueChanged();
			}
		}

		//private methods

		private double TbrValueToTime(TrackBar tbr)
		{
			double ms = m_sharedData.m_longestRoundTime.TotalMilliseconds;
			ms *= tbr.Value;
			ms /= tbr.Maximum;
			return ms;
		}

		private bool ShouldShiftDriven(TrackBar tbrMain, TrackBar tbrDriven)
		{
			bool flag = false;
			if (m_cbPreserve.Checked)
			{
				flag = true;
			}
			else
			{
				Keyboard kbd = new Keyboard();
				if (kbd.ShiftKeyDown)
					flag = true;
				else
					flag = (m_tbrEnd.Value - m_tbrBegin.Value) < MIN_TRACK_DIST;
			}

			return flag && !tbrDriven.Focused;
		}

		private bool TryShiftDriven(ref int oldVal, TrackBar tbrMain, TrackBar tbrDriven)
		{
			bool b = ShouldShiftDriven(tbrMain, tbrDriven);
			if (b)
				SetShiftedVal(ref oldVal, tbrMain, tbrDriven);

			return b;
		}

		private void SetShiftedVal(ref int oldVal, TrackBar tbrMain, TrackBar tbrDriven)
		{
			int delta = tbrMain.Value - oldVal;
			int val = tbrDriven.Value + delta;

			bool minOk = val >= tbrDriven.Minimum;
			bool maxOk = val <= tbrDriven.Maximum;

			if (minOk && maxOk)
			{
				tbrDriven.Value = val;
			}
			else
			{
				int force = 0;
				if (!minOk)
				{
					force = tbrDriven.Minimum - val;
					tbrDriven.Value = tbrDriven.Minimum;
				}
				else //if (!maxOk)
				{
					force = tbrDriven.Maximum - val;
					tbrDriven.Value = tbrDriven.Maximum;
				}

				oldVal = tbrMain.Value + force;//danger: to make next recursive call correct
				tbrMain.Value = oldVal;
			}
		}

		private void OnTbrValueChanged(TrackBar tbrMain, TrackBar tbrDriven, TextBox tbx, ref float filterVal, ref int oldVal)
		{
			TimeSpan span = TimeSpan.FromMilliseconds(TbrValueToTime(tbrMain));
			tbx.Text = span.ToString().Split('.')[0];

			TryShiftDriven(ref oldVal, tbrMain, tbrDriven);

			filterVal = (float)TbrValueToTime(tbrMain) / 1000.0f;
			m_updateDelegate();

			oldVal = tbrMain.Value;
		}

		private int TbxValueToTbrValue(TextBox tbx, TrackBar tbr, TimeSpan defVal)
		{
			TimeSpan span;
			try
			{
				span = TimeSpan.Parse(tbx.Text);
			}
			catch (System.Exception)
			{
				tbx.Text = defVal.ToString().Split('.')[0];
				span = defVal;
			}

			double val = tbr.Maximum * span.TotalMilliseconds;
			val /= m_sharedData.m_longestRoundTime.TotalMilliseconds;

			return (int)Math.Ceiling(val);
		}

		private void OnTbxEnterPressed(TextBox tbx, TrackBar tbr, TimeSpan defVal)
		{
			tbr.Focus(); // used to fix shift recursive issues
			tbr.Value = TbxValueToTbrValue(tbx, tbr, defVal);
		}

		//private data fields
		private TrackBar m_tbrBegin;
		private TrackBar m_tbrEnd;

		private TextBox m_tbxBegin;
		private TextBox m_tbxEnd;
		private TextBox m_tbxLongest;

		private CheckBox m_cbPreserve;

		private SharedData m_sharedData;

		private int[] m_oldTimeFilterVals = new int[2];

		public delegate void UpdateDelegate();
		private UpdateDelegate m_updateDelegate;
	}
}
