using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using StatsTool.Properties;
using System.Drawing;
using System.Drawing.Imaging;
using System.Globalization;
using DdsFileType;
using StatsParse;

namespace StatsTool
{
	public class UniqueList<T>
	{
		private List<T> m_list = new List<T>();

		public virtual void Add(T item)
		{
			if ( !m_list.Contains(item) )
				m_list.Add(item);
		}

		public List<T> Data
		{
			get
			{
				return m_list;
			}
		}
	};


	public class CDrawMan
	{
		private IList<CDrawSameMapSessions> m_sameMapSessions = new List<CDrawSameMapSessions>();

		#region Constructors

		public CDrawMan(Dictionary<string, CSessionRoot> sessions, SharedData sd)
		{
			Dictionary<string, Dictionary<string, CSessionRoot>> ssnDict = new Dictionary<string, Dictionary<string, CSessionRoot>>();

			foreach (KeyValuePair<string, CSessionRoot> kvp in sessions)
			{
				string mapName = kvp.Value.m_mapName;

				if (!ssnDict.ContainsKey(mapName))
					ssnDict.Add(mapName, new Dictionary<string, CSessionRoot>());

				ssnDict[mapName].Add(kvp.Key, kvp.Value);
			}

			int i = 0;
			foreach (KeyValuePair<string, Dictionary<string, CSessionRoot>> kvp in ssnDict)
			{
				sd.m_curMapName = kvp.Key;
				m_sameMapSessions.Add( new CDrawSameMapSessions(kvp.Value, kvp.Key, sd) );
				++i;
			}
		}

		#endregion

		public void DoDraw(Graphics g, SharedData data)
		{
			HideAllEvents();

			int singleIdx = data.m_singleEventIdx;
			if (singleIdx == -1)
			{
				foreach (CDrawSameMapSessions s in m_sameMapSessions)
					if (data.m_categoryFilters[EFilterType.MAP].GetFlag(s.MapName))
						s.DoDraw(g, data);
			}
			else
			{
				data.m_notHidenEvents[singleIdx].Draw(g, data.m_useTargetPos);
			}
		}

		public UniqueList<string> RequestMaps(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestMaps(res);

			return res;
		}

		public UniqueList<string> RequestSessions(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestSessions(res);

			return res;
		}

		public UniqueList<string> RequestRounds(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestRounds(res);

			return res;
		}

		public UniqueList<string> RequestTeams(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestTeams(res);

			return res;
		}

		public UniqueList<string> RequestPlayers(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestPlayers(res);

			return res;
		}

		public UniqueList<string> RequestEventGroups(SharedData data)
		{
			UniqueList<string> res = new UniqueList<string>();

			int idx = 0;
			foreach (EEventGroup eg in Enum.GetValues(typeof(EEventGroup)))
			{
				if (idx != SharedData.CheckAllIdx)
					res.Add( MainFrm.EnumToHumanReadable(eg) );

				++idx;
			}
			
			return res;
		}

		public UniqueList<string> RequestEventTypes( SharedData data )
		{
			UniqueList<string> res = new UniqueList<string>();
			foreach (CDrawSameMapSessions sn in m_sameMapSessions)
				sn.RequestEventTypes(res, data);
			
			return res;
		}

		public void HideAllEvents()
		{
			foreach (CDrawSameMapSessions sms in m_sameMapSessions)
				foreach (CDrawSession sn in sms.Sessions)
					foreach (CDrawRound rd in sn.Rounds)
						foreach (CDrawTeam tm in rd.Teams)
							foreach (CDrawPlayer pl in tm.Players)
								foreach (KeyValuePair<string,IEvent[]> kvp in pl.Events)
									foreach (IEvent ev in kvp.Value)
										ev.Hide();
		}

		public IEvent[] GetNotHidenEvents()
		{
			List<IEvent> evList = new List<IEvent>();

			foreach (CDrawSameMapSessions sms in m_sameMapSessions)
				foreach (CDrawSession sn in sms.Sessions)
					foreach (CDrawRound rd in sn.Rounds)
						foreach (CDrawTeam tm in rd.Teams)
							foreach (CDrawPlayer pl in tm.Players)
								foreach (KeyValuePair<string, IEvent[]> kvp in pl.Events)
									foreach (IEvent ev in kvp.Value)
										if (!ev.Hiden())
											evList.Add(ev);

			return evList.ToArray();
		}

		public IEvent GetEventFromPoint( Vec2 pos )
		{
			IEvent[] evs = GetNotHidenEvents();

			IEvent nearestEv = null;
			float minDist = 9999.0f;
			foreach ( IEvent ev in evs )
			{
				float dist = Vec2.Distance(ev.Pos, pos);
				if ( dist < minDist )
				{
					nearestEv = ev;
					minDist = dist;
				}
			}

			float distCap = 5.0f;
			if ( minDist > distCap)
				return null;

			return nearestEv;
		}

		public TimeSpan GetLongestRoundTime()
		{
			int maxLen = 0;
			foreach (CDrawSameMapSessions sms in m_sameMapSessions)
				foreach (CDrawSession sn in sms.Sessions)
					foreach (CDrawRound rd in sn.Rounds)
						maxLen = Math.Max(maxLen, rd.Length);

			TimeSpan res = TimeSpan.FromMilliseconds( maxLen );
			int ms = res.Milliseconds;
			if ( ms > 0 )
				res.Add( TimeSpan.FromMilliseconds(1000 - ms) );

			return res;
		}

		public IList<CDrawSameMapSessions> SameMapSessions
		{
			get
			{
				return m_sameMapSessions;
			}
		}
	}
}