using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using StatsTool.Properties;
using System.Drawing;
using System.Drawing.Imaging;
using System.Globalization;
using DdsFileType;
using StatsParse;

namespace StatsTool
{
	public class CDrawRound
	{
		private IList<CDrawTeam> m_teams = new List<CDrawTeam>();
		private string m_name;
		private CDrawSession m_parent;
		private int m_begin, m_end;

		#region Constructors

		public CDrawRound(CRoundData round, int num, CTeamData[] teams, CDrawSession parent, SharedData sd)
		{
			m_name = "Round_" + num.ToString();
			m_parent = parent;
			m_begin = round.m_begin;
			m_end = round.m_end;

			int teamCnt = teams.Length;

			m_teams = new CDrawTeam[teamCnt];
			for (int tm = 0; tm < teamCnt; ++tm)
				m_teams[tm] = new CDrawTeam(teams[tm].m_id, round, sd, this);
		}

		#endregion

		public void DoDraw(Graphics g, SharedData data)
		{
			int id = 1;
			foreach (CDrawTeam t in m_teams)
			{
				if (data.m_categoryFilters[EFilterType.TEAM].GetFlag(t.Name))
					t.DoDraw(g,CDrawTeam.GetTeamColor(id), data);
				++id;
			}
		}

		public void RequestTeams(UniqueList<string> res)
		{
			foreach (CDrawTeam tm in Teams)
				res.Add(tm.Name);
		}

		public void RequestPlayers(UniqueList<string> res)
		{
			foreach (CDrawTeam tm in Teams)
				tm.RequestPlayers(res);
		}

		public void RequestEventTypes(UniqueList<string> res, SharedData data)
		{
			foreach (CDrawTeam tm in Teams)
				tm.RequestEventTypes(res, data);
		}

		public Dictionary<uint, string> GetEntityAliases()
		{
			Dictionary<uint, string> res = new Dictionary<uint, string>();
			foreach (CDrawTeam tm in Teams)
				foreach (CDrawPlayer pl in tm.Players)
					if ( !res.ContainsKey(pl.Id) )
						res.Add(pl.Id, pl.Name);

			return res;
		}

		public IList<CDrawTeam> Teams
		{
			get
			{
				return m_teams;
			}
		}

		public string Name
		{
			get
			{
				return m_name;
			}
		}

		public CDrawSession Parent
		{
			get
			{
				return m_parent;
			}
		}

		public int Begin
		{
			get
			{
				return m_begin;
			}
		}

		public int Length
		{
			get
			{
				int res = m_end - m_begin;

				bool good = res >= 0;
				//System.Diagnostics.Debug.Assert( good );
				if (!good)
					return 0;

				return res;
			}
		}
	}
}
