using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using StatsParse;

namespace StatsTool
{
	public class CDrawSameMapSessions
	{
		private IList<CDrawSession> m_sessions = new List<CDrawSession>();
		private string m_mapName;

		#region Constructors

		public CDrawSameMapSessions(Dictionary<string, CSessionRoot> sessions, string mapName, SharedData sd)
		{
			m_mapName = mapName;			
			foreach (KeyValuePair<string, CSessionRoot> kvp in sessions)
			{
				CDrawSession session = new CDrawSession(kvp.Value, kvp.Key, sd);
				if (session.Rounds == null)
					continue;

				m_sessions.Add(session);
			}
		}

		public CDrawSameMapSessions(IList<CDrawSession> sessions, string mapName)
		{
			m_mapName = mapName;
			m_sessions = sessions;
		}

		#endregion

		public void DoDraw(Graphics g, SharedData data)
		{
			foreach (CDrawSession s in m_sessions)
				if (data.m_categoryFilters[EFilterType.SESSION].GetFlag(s.Name))
					s.DoDraw(g, data);
		}

		public void RequestMaps(UniqueList<string> res)
		{
			res.Add(m_mapName);
		}

		public void RequestSessions(UniqueList<string> res)
		{
			foreach (CDrawSession s in m_sessions)
				res.Add(s.Name);
		}

		public void RequestRounds(UniqueList<string> res)
		{
			foreach (CDrawSession s in m_sessions)
				s.RequestRounds(res);
		}

		public void RequestTeams(UniqueList<string> res)
		{
			foreach (CDrawSession s in m_sessions)
				s.RequestTeams(res);
		}

		public void RequestPlayers(UniqueList<string> res)
		{
			foreach (CDrawSession s in m_sessions)
				s.RequestPlayers(res);
		}

		public void RequestEventTypes(UniqueList<string> res, SharedData data)
		{
			foreach (CDrawSession s in m_sessions)
				s.RequestEventTypes(res, data);
		}

		public string MapName
		{
			get
			{
				return m_mapName;
			}
		}

		public IList<CDrawSession> Sessions
		{
			get
			{
				return m_sessions;
			}
		}

	}
}